% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichKO.R
\name{enrichKO}
\alias{enrichKO}
\title{KO enrichment for microbiome data}
\usage{
enrichKO(
  gene,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe = NULL,
  minGSSize = 10,
  maxGSSize = 500,
  qvalueCutoff = 0.2
)
}
\arguments{
\item{gene}{a vector of K gene id (e.g. K00001) or EC id (e.g. 1.1.1.27).}

\item{pvalueCutoff}{adjusted pvalue cutoff on enrichment tests to report.}

\item{pAdjustMethod}{one of "holm","hochberg","hommel","bonferroni","BH",
"BY","fdr","none".}

\item{universe}{universe background genes. If missing, use all K genes.}

\item{minGSSize}{minimal size of genes annotated by KEGG term for testing.}

\item{maxGSSize}{maximal size of genes annotated for testing.}

\item{qvalueCutoff}{qvalue cutoff on enrichment tests to report.}
}
\value{
A \code{enrichResult} instance.
}
\description{
KO enrichment for microbiome data
}
\examples{

  data(Rat_data)
  ko <- enrichKO(Rat_data)
  head(ko)

}
