% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FEA.R
\name{FEA}
\alias{FEA}
\title{FEA}
\usage{
FEA(BPname = NULL, DEGsmatrix)
}
\arguments{
\item{BPname}{BPname biological process such as "proliferation of cells", "ALL" (default) if FEA should be carried out for all 101 biological processes}

\item{DEGsmatrix}{DEGsmatrix output from DEA such as dataDEGs}
}
\value{
matrix from FEA
}
\description{
This function carries out the functional enrichment analysis (FEA)
}
\examples{
data(DEGsmatrix)
data(DiseaseList)
data(EAGenes)
DEGsmatrix <- DEGsmatrix[seq.int(2), ]
dataFEA <- FEA(DEGsmatrix = DEGsmatrix, BPname = "apoptosis")
}
