% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMoonlight.R
\name{plotMoonlight}
\alias{plotMoonlight}
\title{plotMoonlight}
\usage{
plotMoonlight(
  DEG_Mutations_Annotations,
  Oncogenic_mediators_mutation_summary,
  dataURA,
  gene_type = "drivers",
  n = 50,
  genelist = c(),
  BPlist = c(),
  additionalFilename = ""
)
}
\arguments{
\item{DEG_Mutations_Annotations}{A tibble, output file from DMA.}

\item{Oncogenic_mediators_mutation_summary}{A tibble, output file from DMA.}

\item{dataURA}{Output URA function.}

\item{gene_type}{A character string either \code{"mediators"} or \code{"drivers"}.
\itemize{
\item If \code{NULL} defaults to \code{"drivers"}.
\item \code{"mediators"} will show the oncogenic mediators with the highst number of mutations regardless of driver/passenger classification.
\item \code{"drivers"} will show the driver genes with the highest number of driver mutations.
}}

\item{n}{Numeric. The top number of genes to be plotted. If \code{NULL} defaults to 50.}

\item{genelist}{A vector of strings containing Hugo Symbols of genes.
Overwrites \code{gene_type} argument.}

\item{BPlist}{A vector of strings. Selection of the biological processes to visualise.
If left empty defaults to every BP provided in the URA file.}

\item{additionalFilename}{A character string. Adds prefix or filepath to the filename of the pdf.}
}
\value{
No return value. Moonlight scores are plotted for selected genes.
}
\description{
This function creates a heatmap of Moonlight gene z-scores for selected genes.
}
\examples{
data(DEG_Mutations_Annotations)
data(Oncogenic_mediators_mutation_summary)
data(dataURA_plot)
plotMoonlight(DEG_Mutations_Annotations,
              Oncogenic_mediators_mutation_summary,
              dataURA_plot, genelist = c("AFAP1L1", "ABCG2"),
              additionalFilename = "myplot_")
}
