% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CpG_sites_analysis.R
\name{annotate_cpg_sites}
\alias{annotate_cpg_sites}
\title{Annotate CpG sites}
\usage{
annotate_cpg_sites(mutation_data, motif = "CG", column_query = "context", ...)
}
\arguments{
\item{mutation_data}{A dataframe or GRanges object containing the genomic
regions of interest in which to look for CpG sites.}

\item{motif}{Default "CG", which returns CpG sites. You could in theory use
an arbitrary string to look at different motifs. Use with caution. In this
case the pattern being searched must be a column in the mutation data.}

\item{column_query}{Default "context" but can be any column  in the mutation
data that you wish to look for a motif in.}

\item{...}{Additional arguments to vcountPattern()}
}
\value{
A data frame with the same number of rows as there were ranges in
the input, but with an additional metadata column indicating CpG sites in
the target sequence of the mutation.
}
\description{
A simple method to test whether your trinucleotide context contains a CpG
site.  Vectorized version of Biostrings::vcountPattern is used.
}
