% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_sigprofiler_input.R
\name{write_mutation_calling_file}
\alias{write_mutation_calling_file}
\title{Write the mutation calling file to input into the SigProfiler Assignment
web application.}
\usage{
write_mutation_calling_file(
  mutation_data,
  project_name = "Example",
  project_genome = "GRCm38",
  output_path = NULL
)
}
\arguments{
\item{mutation_data}{The object containing the mutation data.
The output of import_mut_data() or import_vcf_data().}

\item{project_name}{The name of the project. Default is "Example".}

\item{project_genome}{The reference genome to use.
(e.g., Human: GRCh38, Mouse mm10: GRCm38)}

\item{output_path}{The path to save the output file. If NULL, files
will be saved in the current working directory. Default is NULL.}
}
\value{
a .txt file that can be uploaded to the SigProfiler Assignment web
application (https://cancer.sanger.ac.uk/signatures/assignment/) as a
"Mutational calling file".
}
\description{
Creates a .txt file from mutation data that can be used for mutational
signatures analysis using the SigProfiler Assignment web application.
Currently only supports SBS analysis i.e. snvs.
}
\details{
Mutations will be be filtered for SNVs. Mutations flagged in
\code{filter_mut} will be excluded from the output.
}
\examples{
# Example data  consists of 24 mouse bone marrow
# samples exposed to three doses of BaP alongside vehicle controls.
# Libraries were sequenced with Duplex Sequencing using
# the TwinStrand Mouse Mutagenesis Panel which consists of 20 2.4kb
# targets = 48kb of sequence. Example data can be retrieved from
# MutSeqRData, an ExperimentHub data package:
## library(ExperimentHub)
## eh <- ExperimentHub()
## query(eh, "MutSeqRData")
# The data is a subset of variants from the target chr1
# from samples of the high dose group (50mg).
example_data <- readRDS(system.file("extdata", "Example_files",
                                    "variants_subset_d50_chr1.rds",
                                     package = "MutSeqR")
)
 write_mutation_calling_file(
    mutation_data = example_data,
    project_name = "Example",
    project_genome = "GRCm38",
    output_path = tempdir()
  )
  list.files(tempdir())
  # The file is saved in the temporary directory
  # To view the file, use the following code:
  ## output_file <- file.path(tempdir(), "mutation_calling_file.txt")
  ## file.show(output_file)
}
