% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpo.R
\name{hpo_download}
\alias{hpo_download}
\title{Downloads protein annotations from Human Phenotype Ontology}
\usage{
hpo_download()
}
\value{
A tibble (data frame) of annotations as it is provided by the
database
}
\description{
Human Phenotype Ontology (HPO) provides a standardized vocabulary of
phenotypic abnormalities encountered in human disease. Each term in the
HPO describes a phenotypic abnormality. HPO currently contains over 13,000
terms and over 156,000 annotations to hereditary diseases. See more at
\url{https://hpo.jax.org/app/}.
}
\examples{
hpo_data <- hpo_download()
hpo_data
# # A tibble: 231,738 x 9
#    entrez_gene_id entrez_gene_symb. hpo_term_id hpo_term_name
#             <dbl> <chr>             <chr>       <chr>
#  1           8192 CLPP              HP:0000013  Hypoplasia of the ute.
#  2           8192 CLPP              HP:0004322  Short stature
#  3           8192 CLPP              HP:0000786  Primary amenorrhea
#  4           8192 CLPP              HP:0000007  Autosomal recessive i.
#  5           8192 CLPP              HP:0000815  Hypergonadotropic hyp.
# # . with 231,733 more rows, and 5 more variables:
# #   frequency_raw <chr>, frequency_hpo <chr>, info_gd_source <chr>,
# #   gd_source <chr>, disease_id <chr>

}
