% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactions.R
\name{omnipath-interactions}
\alias{omnipath-interactions}
\alias{omnipath_interactions}
\alias{import_omnipath_interactions}
\alias{omnipath}
\alias{pathwayextra}
\alias{import_pathwayextra_interactions}
\alias{kinaseextra}
\alias{import_kinaseextra_interactions}
\alias{ligrecextra}
\alias{import_ligrecextra_interactions}
\alias{post_translational}
\alias{import_post_translational_interactions}
\alias{dorothea}
\alias{import_dorothea_interactions}
\alias{tf_target}
\alias{import_tf_target_interactions}
\alias{transcriptional}
\alias{import_transcriptional_interactions}
\alias{collectri}
\alias{mirna_target}
\alias{import_mirnatarget_interactions}
\alias{tf_mirna}
\alias{import_tf_mirna_interactions}
\alias{lncrna_mrna}
\alias{import_lncrna_mrna_interactions}
\alias{small_molecule}
\alias{import_small_molecule_protein_interactions}
\alias{all_interactions}
\alias{import_all_interactions}
\title{Molecular interactions from OmniPath}
\usage{
omnipath_interactions(...)

omnipath(...)

pathwayextra(...)

kinaseextra(...)

ligrecextra(...)

post_translational(...)

dorothea(dorothea_levels = c("A", "B"), ...)

tf_target(...)

transcriptional(dorothea_levels = c("A", "B"), ...)

collectri(...)

mirna_target(...)

tf_mirna(...)

lncrna_mrna(...)

small_molecule(...)

all_interactions(
  dorothea_levels = c("A", "B"),
  types = NULL,
  fields = NULL,
  exclude = NULL,
  ...
)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}, \code{\link[=omnipath_query]{omnipath_query}}
  \describe{
    \item{\code{organism}}{Character or integer: name or NCBI Taxonomy ID of the
organism. OmniPath is built of human data, and the web service provides
orthology translated interactions and enzyme-substrate relationships for
mouse and rat. For other organisms and query types, orthology
translation will be called automatically on the downloaded human data
before returning the result.}
    \item{\code{resources}}{Character vector: name of one or more resources. Restrict
the data to these resources. For a complete list of available resources,
call the `<query_type>_resources` functions for the query type of
interst.}
    \item{\code{datasets}}{Character vector: name of one or more datasets. In the
interactions query type a number of datasets are available. The default
is caled "omnipath", and corresponds to the curated causal signaling
network published in the 2016 OmniPath paper.}
    \item{\code{genesymbols}}{Character or logical: TRUE or FALS or "yes" or "no".
Include the `genesymbols` column in the results. OmniPath uses UniProt
IDs as the primary identifiers, gene symbols are optional.}
    \item{\code{default_fields}}{Logical: if TRUE, the default fields will be included.}
    \item{\code{silent}}{Logical: if TRUE, no messages will be printed. By default a
summary message is printed upon successful download.}
    \item{\code{logicals}}{Character vector: fields to be cast to logical.}
    \item{\code{format}}{Character: if "json", JSON will be retrieved and processed
into a nested list; any other value will return data frame.}
    \item{\code{download_args}}{List: parameters to pass to the download function,
which is \code{readr::read_tsv} by default, and
\code{jsonlite::stream_in} if \code{format = "json"}. Note: as these are
both wrapped into a downloader using \code{curl::curl}, a curl handle
can be also passed here under the name \code{handle}.}
    \item{\code{references_by_resource}}{Logical: if TRUE,, in the `references`
column the PubMed IDs will be prefixed with the names of the resources
they are coming from. If FALSE, the `references` column will be a list
of unique PubMed IDs.}
    \item{\code{add_counts}}{Logical: if TRUE, the number of references and number of
resources for each record will be added to the result.}
    \item{\code{license}}{Character: license restrictions. By default, data from
resources allowing "academic" use is returned by OmniPath. If you use
the data for work in a company, you can provide "commercial" or
"for-profit", which will restrict the data to those records which are
supported by resources that allow for-profit use.}
    \item{\code{password}}{Character: password for the OmniPath web service. You can
provide a special password here which enables the use of `license =
"ignore"` option, completely bypassing the license filter.}
    \item{\code{json_param}}{List: parameters to pass to the `jsonlite::fromJSON` when
processing JSON columns embedded in the downloaded data. Such columns
are "extra_attrs" and "evidences". These are optional columns which
provide a lot of extra details about interactions.}
    \item{\code{strict_evidences}}{Logical: reconstruct the "sources" and "references"
columns of interaction data frames based on the "evidences" column,
strictly filtering them to the queried datasets and resources. Without
this, the "sources" and "references" fields for each record might
contain information for datasets and resources other than the queried
ones, because the downloaded records are a result of a simple filtering
of an already integrated data frame.}
    \item{\code{genesymbol_resource}}{Character: "uniprot" (default) or "ensembl". The
OmniPath web service uses the primary gene symbols as provided by
UniProt. By passing "ensembl" here, the UniProt gene symbols will be
replaced by the ones used in Ensembl. This translation results in a loss
of a few records, and multiplication of another few records due to
ambiguous translation.}
    \item{\code{cache}}{Logical: use caching, load data from and save to the. The cache
directory by default belongs to the user, located in the user's default
cache directory, and named "OmnipathR". Find out about it by
\code{getOption("omnipathr.cachedir")}. Can be changed by
\code{\link{omnipath_set_cachedir}}.}
  }}

\item{dorothea_levels}{The confidence levels of the dorothea
interactions (TF-target) which range from A to D. Set to A and B by
default.}

\item{types}{Character: interaction types, such as "transcriptional",
"post_transcriptional", "post_translational", etc.}

\item{fields}{Character: additional fields (columns) to be included in the
result. For a list of available fields, see \code{\link{query_info}}.}

\item{exclude}{Character: names of datasets or resource to be excluded from
the result. By deafult, the records supported by only these resources or
datasets will be removed from the output. If \code{strict_evidences =
TRUE}, the resource, reference and causality information in the data
frame will be reconstructed to remove all information coming from the
excluded resources.}
}
\value{
A dataframe of molecular interactions.

A dataframe of literature curated, post-translational signaling
    interactions.

A dataframe containing activity flow interactions between proteins
without literature reference

A dataframe containing enzyme-substrate interactions without
literature reference

A dataframe containing ligand-receptor interactions including
the ones without literature references

A dataframe containing post-translational interactions

A data frame of TF-target interactions from DoRothEA.

A dataframe containing TF-target interactions

A dataframe containing TF-target interactions.

A dataframe of TF-target interactions.

A dataframe containing miRNA-mRNA interactions

A dataframe containing TF-miRNA interactions

A dataframe containing lncRNA-mRNA interactions

A dataframe of small molecule-protein interactions

A dataframe containing all the datasets in the interactions query
}
\description{
The functions listed here all download pairwise, causal molecular
interactions from the \url{https://omnipathdb.org/interactions} endpoint of
the OmniPath web service. They are different only in the type of
interactions and the kind of resources and data they have been compiled
from. A complete list of these functions is available below, these cover
the interaction datasets and types  currently available in OmniPath:

Interactions from the \url{https://omnipathdb.org/interactions} endpoint of
the OmniPath web service.
By default, it downloads only the "omnipath" dataset, which corresponds to
the curated causal interactions described in Turei et al. 2016.

Imports interactions from the `omnipath` dataset of OmniPath, a dataset
that inherits most of its design and contents from the original OmniPath
core from the 2016 publication. This dataset consists of about 40k
interactions.

Imports the dataset from:
\url{https://omnipathdb.org/interactions?datasets=pathwayextra},
which contains activity flow interactions without literature reference.
The activity flow interactions supported by literature references
are part of the `omnipath` dataset.

Imports the dataset from:
\url{https://omnipathdb.org/interactions?datasets=kinaseextra},
which contains enzyme-substrate interactions without literature reference.
The enzyme-substrate interactions supported by literature references
are part of the `omnipath` dataset.

Imports the dataset from:
\url{https://omnipathdb.org/interactions?datasets=ligrecextra},
which contains ligand-receptor interactions without literature reference.
The ligand-receptor interactions supported by literature references
are part of the `omnipath` dataset.

Imports interactions from all post-translational datasets of OmniPath.
The datasets are "omnipath", "kinaseextra", "pathwayextra" and
"ligrecextra".

Imports the dataset from:
\url{https://omnipathdb.org/interactions?datasets=dorothea}
which contains transcription factor (TF)-target interactions from DoRothEA
\url{https://github.com/saezlab/DoRothEA}
DoRothEA is a comprehensive resource of transcriptional regulation,
consisting of 16 original resources, in silico TFBS prediction, gene
expression signatures and ChIP-Seq binding site analysis.

Imports the dataset from:
\url{https://omnipathdb.org/interactions?datasets=tf_target},
which contains transcription factor-target protein coding gene
interactions. Note: this is not the only TF-target dataset in OmniPath,
`dorothea` is the other one and the `tf_mirna` dataset provides
TF-miRNA gene interactions.

Imports the dataset from:
\url{https://omnipathdb.org/interactions?datasets=tf_target,dorothea},
which contains transcription factor-target protein coding gene
interactions.

CollecTRI is a comprehensive resource of transcriptional regulation,
published in 2023, consisting of 14 resources and original literature
curation.

Imports the dataset from:
\url{https://omnipathdb.org/interactions?datasets=mirnatarget},
which contains miRNA-mRNA interactions.

Imports the dataset from:
\url{https://omnipathdb.org/interactions?datasets=tf_mirna},
which contains transcription factor-miRNA gene interactions

Imports the dataset from:
\url{https://omnipathdb.org/interactions?datasets=lncrna_mrna},
which contains lncRNA-mRNA interactions

Imports the dataset from:
\url{https://omnipathdb.org/interactions?datasets=small_molecule},
which contains small molecule-protein interactions. Small molecules
can be metabolites, intrinsic ligands or drug compounds.
}
\details{
\strong{Post-translational (protein-protein, PPI) interactions}

\itemize{
\item{\code{omnipath}: the OmniPath data as defined in the 2016 paper,
an arbitrary optimum between coverage and quality. This dataset
contains almost entirely causal (stimulatory or inhibitory; i.e.
activity flow , according to the SBGN standard), physical
interactions between pairs of proteins, curated by experts
from the literature.}
\item{\code{pathwayextra}: activity flow interactions without literature
references.}
\item{\code{kinaseextra}: enzyme-substrate interactions without
literature references.}
\item{\code{ligrecextra}: ligand-receptor interactions without
literature references.}
\item{\code{post_translational}: all post-translational
(protein-protein, PPI) interactions; this is the combination of the
\emph{omnipath}, \emph{pathwayextra}, \emph{kinaseextra} and \emph{ligrecextra}
datasets.}
}

\strong{TF-target (gene regulatory, GRN) interactions}

\itemize{
\item{\code{collectri}: transcription factor (TF)-target
interactions from CollecTRI.}
\item{\code{dorothea}: transcription factor (TF)-target
interactions from DoRothEA}
\item{\code{tf_target}: transcription factor
(TF)-target interactions from other resources}
\item{\code{transcriptional}: all transcription factor
(TF)-target interactions; this is the combination of the
\emph{collectri}, \emph{dorothea} and \emph{tf_target} datasets.}
}

\strong{Post-transcriptional (miRNA-target) and other RNA related interactions}

In these datasets we intend to collect the literature curated resources,
hence we don't include some of the most well known large databases if those
are based on predictions or high-throughput assays.

\itemize{
\item{\code{mirna_target}: miRNA-mRNA interactions}
\item{\code{tf_mirna}: TF-miRNA interactions}
\item{\code{lncrna_mrna}: lncRNA-mRNA interactions}
}

\strong{Other interaction access functions}

\itemize{
\item{\code{small_molecule}: interactions between small molecules and
proteins. Currently this is a small, experimental dataset that
includes drug-target, ligand-receptor, enzyme-metabolite and other
interactions. In the future this will be largely expanded and
divided into multiple datasets.}
\item{\code{all_interactions}: all the interaction datasets combined.}
}
}
\examples{
op <- omnipath(resources = c("CA1", "SIGNOR", "SignaLink3"))
op

interactions = omnipath_interactions(
    resources = "SignaLink3",
    organism = 9606
)

pathways <- omnipath()
pathways

interactions <-
    pathwayextra(
        resources = c("BioGRID", "IntAct"),
        organism = 9606
    )

kinase_substrate <-
   kinaseextra(
       resources = c('PhosphoPoint', 'PhosphoSite'),
       organism = 9606
   )

ligand_receptor <- ligrecextra(
    resources = c('HPRD', 'Guide2Pharma'),
    organism = 9606
)

interactions <- post_translational(resources = "BioGRID")

dorothea_grn <- dorothea(
    resources = c('DoRothEA', 'ARACNe-GTEx_DoRothEA'),
    organism = 9606,
    dorothea_levels = c('A', 'B', 'C')
)
dorothea_grn

interactions <- tf_target(resources = c("DoRothEA", "SIGNOR"))

grn <- transcriptional(resources = c("PAZAR", "ORegAnno", "DoRothEA"))
grn

collectri_grn <- collectri()
collectri_grn

interactions <- mirna_target( resources = c("miRTarBase", "miRecords"))

interactions <- tf_mirna(resources = "TransmiR")

interactions <- lncrna_mrna(resources = c("ncRDeathDB"))

# What are the targets of aspirin?
interactions <- small_molecule(sources = "ASPIRIN")
# The prostaglandin synthases:
interactions

interactions <- all_interactions(
    resources = c("HPRD", "BioGRID"),
    organism = 9606
)

}
\seealso{
\itemize{
\item{\code{\link{interaction_resources}}}
\item{\code{\link{interaction_graph}}}
\item{\code{\link{print_interactions}}}
\item{\code{\link{annotated_network}}}
}

\itemize{
    \item{\code{\link{omnipath_interactions}}}
    \item{\code{\link{post_translational}}}
    \item{\code{\link{interaction_resources}}}
    \item{\code{\link{all_interactions}}}
    \item{\code{\link{interaction_graph}}}
    \item{\code{\link{print_interactions}}}
}
}
