% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{omnipath_cache_move_in}
\alias{omnipath_cache_move_in}
\title{Moves an existing file into the cache}
\usage{
omnipath_cache_move_in(
  path,
  key = NULL,
  version = NULL,
  url = NULL,
  post = NULL,
  payload = NULL,
  keep_original = FALSE
)
}
\arguments{
\item{path}{Path to the source file}

\item{key}{Key of the cache item}

\item{version}{Version of the cache item. If does not exist a new version
item will be created}

\item{url}{URL of the downloaded resource}

\item{post}{HTTP POST parameters as a list}

\item{payload}{HTTP data payload}

\item{keep_original}{Whether to keep or remove the original file}
}
\value{
Character: invisibly returns the version number of the cache
    version item.
}
\description{
Either the key or the URL (with POST and payload) must be provided.
}
\examples{
path <- tempfile()
saveRDS(rnorm(100), file = path)
omnipath_cache_move_in(path, url = 'the_download_address')

# basic example of moving a file to the cache:

bioc_url <- 'https://bioconductor.org/'
html_file <- tempfile(fileext = '.html')
curl::curl_fetch_disk(bioc_url, html_file)
omnipath_cache_move_in(path = html_file, url = bioc_url)
omnipath_cache_remove(url = bioc_url) # cleaning up

}
\seealso{
\code{\link{omnipath_cache_save}}
}
