% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bma.R
\name{print_bma_motif_vs}
\alias{print_bma_motif_vs}
\title{Prints BMA motifs to the screen from a sequence of nodes}
\usage{
print_bma_motif_vs(node_seq, G)
}
\arguments{
\item{node_seq}{An igraph node sequence.}

\item{G}{An igraph graph object.}
}
\value{
Returns `NULL`.
}
\description{
The motifs can be copy-pasted into a BMA canvas.
}
\examples{
interactions <- omnipath(resources = "ARN")
graph <- interaction_graph(interactions)
print_bma_motif_vs(
    igraph::all_shortest_paths(
        graph,
        from = 'ULK1',
        to = 'ATG13'
    )$res,
    graph
)

}
