% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stitch.R
\name{stitch_network}
\alias{stitch_network}
\title{Chemical-protein interactions from STITCH}
\usage{
stitch_network(
  organism = "human",
  min_score = 700L,
  protein_ids = c("uniprot", "genesymbol"),
  metabolite_ids = c("hmdb", "kegg"),
  cosmos = FALSE,
  metabolite_protein_only = FALSE
)
}
\arguments{
\item{organism}{Character or integer: name or NCBI Taxonomy ID of an
organism. STITCH supports many organisms, please refer to their web site
at \url{https://stitch.embl.de/}.}

\item{min_score}{Confidence cutoff used for STITCH connections
(700 by default).}

\item{protein_ids}{Character: translate the protein identifiers to these ID
types. Each ID type results two extra columns in the output, for the "a"
and "b" sides of the interaction, respectively. The default ID type for
proteins is Esembl Protein ID, and by default UniProt IDs and Gene
Symbols are included.}

\item{metabolite_ids}{Character: translate the protein identifiers to these ID
types. Each ID type results two extra columns in the output, for the "a"
and "b" sides of the interaction, respectively. The default ID type for
metabolites is PubChem CID, and HMDB IDs and KEGG IDs are included.}

\item{cosmos}{Logical: use COSMOS format?}

\item{metabolite_protein_only}{Logical: keep only metabolite-protein
interactions, remove protein-metabolite ones.}
}
\value{
A data frame of STITCH chemical-protein and protein-chemical
interactions with their effect signs, and optionally with identifiers
translated.
}
\description{
Chemical-protein interactions from STITCH
}
\examples{
stn <- stitch_network(protein_ids = 'genesymbol', metabolite_ids = 'hmdb')

}
\seealso{
\itemize{
    \item{\code{\link{stitch_actions}}}
    \item{\code{\link{stitch_links}}}
    \item{\code{\link{stitch_remove_prefixes}}}
}
}
