% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{subnetwork}
\alias{subnetwork}
\title{Extract a custom subnetwork from a large network}
\usage{
subnetwork(
  network,
  nodes = NULL,
  order = 1L,
  mode = "all",
  mindist = 0L,
  return_df = TRUE
)
}
\arguments{
\item{network}{Either an OmniPath interaction data frame, or an igraph
graph object.}

\item{nodes}{Character or integer vector: names, identifiers or indices
of the nodes to build the subnetwork around.}

\item{order}{Integer: order of neighbourhood around nodes; i.e., number
of steps starting from the provided nodes.}

\item{mode}{Character: "all", "out" or "in". Follow directed edges from
the provided nodes in any, outbound or inbound direction, respectively.}

\item{mindist}{Integer: The minimum distance to include the vertex in the
result.}

\item{return_df}{Logical: return an interaction data frame instead of an
igraph object.}
}
\value{
A network data frame or an igraph object, depending on the
    ``return_df`` parameter.
}
\description{
Extract a custom subnetwork from a large network
}
\seealso{
\itemize{
    \item{\code{\link{interaction_graph}}}
    \item{\code{\link{graph_interaction}}}
    \item{\code{\link{show_network}}}
}
}
