% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIUMA_Import.R
\name{makeTDAobj}
\alias{makeTDAobj}
\title{Import data and generate the TDAobj object}
\usage{
makeTDAobj(df, outcomes)
}
\arguments{
\item{df}{A data.frame representing a dataset in the classical n x m form.
Rows (n) and columns (m) should be, respectively, observations and features.}

\item{outcomes}{A string or vector of string containing the name of variables
that have to be considered 'outcomes'}
}
\value{
A TDA object containing:
\itemize{
  \item  orig_data A data.frame of original data (without outcomes)
  \item  scaled_data A data.frame of re-scaled data (without outcomes)
  \item  outcomeFact A data.frame of original outcomes
  \item  outcome A data.frame of original outcomes converted as numeric
  \item  comp A data.frame containing the components of projected data
  \item  dist_mat A data.frame containing the computed distance matrix
  \item  dfMapper A data.frame containing the nodes, with their elements,
identified by TDA
  \item  jacc A matrix of Jaccard indexes between each pair of dfMapper nodes
  \item  node_data_mat A data.frame with the node size and the average value
  \item  graph A list containing the igraph object derived from Jaccard
  matrix and intermediary objects
  \item  clustering A list containing two data.frames indicating the
   clustering per node and per rows
  }
}
\description{
This function import a data.frame and create the object to
store all data needed for TDA analysis. In addition, some preliminary
preprocess steps are performed; specifically, outcomes variables data will
be separated the rest of dataset. The remaining dataset will be also
re-scaled (0-1)
}
\examples{
## use example data:
data("vascEC_meta")
data("vascEC_norm")
df <- cbind(vascEC_meta, vascEC_norm)
res <- makeTDAobj(df, "zone")

}
\author{
Mattia Chiesa, Laura Ballarini, Luca Piacentini, Carlo Leonardi
}
