% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIUMA_Enrichment.R
\name{tdaDfEnrichment}
\alias{tdaDfEnrichment}
\title{Add information to TDAobj}
\usage{
tdaDfEnrichment(x, df)
}
\arguments{
\item{x}{A TDAobj object, processed by the  \code{\link{mapperCore}}
function.}

\item{df}{A data.frame with scaled values in the classical n x m form:
rows (n) and columns (m) must be observations and features, respectively.}
}
\value{
The starting TDAobj object, in which the a data.frame with additional
 information for each node has been added (slot: 'node_data_mat')
}
\description{
This function computes the average value of additional features
provided by the user and calculate the size for each node of 'dfMapper' slot
}
\examples{
## use example data:
data(tda_test_data)
data(df_test_proj)
enrich_mat_tda <- tdaDfEnrichment(tda_test_data, df_test_proj)

}
\seealso{
\code{\link{makeTDAobj}},
\code{\link{dfToDistance}},
\code{\link{dfToProjection}},
\code{\link{mapperCore}},
\code{\link{jaccardMatrix}}
}
\author{
Mattia Chiesa, Laura Ballarini, Luca Piacentini
}
