% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{PreFL}
\alias{PreFL}
\title{Prefiltering for Microbiome Count Data}
\usage{
PreFL(data, keep.spl = 10, keep.var = 0.01)
}
\arguments{
\item{data}{A numeric matrix or data frame with samples in rows and
variables in columns.}

\item{keep.spl}{Numeric, the minimum total count of a sample to be kept.
Samples with a total count smaller than \code{keep.spl} are removed.
Default is \code{10}.}

\item{keep.var}{Numeric, the minimum percentage (between \code{0} and
\code{100}) of total counts a variable must contribute to be kept.
For example, \code{keep.var = 0.01} keeps variables that account for
at least \code{0.01\%} of the total counts. Default is \code{0.01}.}
}
\value{
\code{PreFL} returns a list that contains the following components:
\item{data.filter}{The filtered data matrix.}
\item{sample.idx}{The indices of samples kept.}
\item{var.idx}{The indices of variables kept.}
\item{zero.prob.before}{The proportion of zeros in the input data.}
\item{zero.prob.after}{The proportion of zeros after filtering.}
}
\description{
This function prefilters microbiome count data to remove samples or microbial
variables with very low abundance.
}
\examples{
if (requireNamespace("SummarizedExperiment", quietly = TRUE)) {
    data("AD_data")

    ad.count <- SummarizedExperiment::assays(AD_data$FullData)$Count
    ad.filter.res <- PreFL(data = ad.count)

    ad.filter <- ad.filter.res$data.filter
    ad.zero.before <- ad.filter.res$zero.prob.before
    ad.zero.after <- ad.filter.res$zero.prob.after
}

}
\references{
\insertRef{le2016mixmc}{PLSDAbatch}
}
\author{
Yiwen Wang, Kim-Anh Le Cao
}
