% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsda_batch.R
\name{deflate_mtx}
\alias{deflate_mtx}
\title{Matrix Deflation}
\usage{
deflate_mtx(X, comp)
}
\arguments{
\item{X}{A numeric matrix to be deflated. It assumes that samples are
on the rows and variables are on the columns. \code{NA}s are not allowed.}

\item{comp}{A numeric vector or single-column matrix representing the
component to be deflated out from the matrix.}
}
\value{
A deflated matrix with the same dimension as the input matrix.
}
\description{
This function removes the variance of a given component \code{comp} from the
input matrix \code{X}. \deqn{\hat{X} = X - comp (comp^{\top}comp)^{-1}comp^{\top}X}
It is mainly used internally in \code{PLSDA_batch}.
}
\examples{
NULL

}
\references{
\insertRef{barker2003partial}{PLSDAbatch}
}
\author{
Yiwen Wang, Kim-Anh Le Cao
}
\keyword{Internal}
