% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_assessment.R
\name{partVar_plot}
\alias{partVar_plot}
\title{Partitioned Variance Plot}
\usage{
partVar_plot(
  prop.df,
  text.cex = 3,
  x.angle = 60,
  x.hjust = 1,
  title = NULL,
  color.set = NULL
)
}
\arguments{
\item{prop.df}{A data frame that contains the proportion of variance
explained by different sources.}

\item{text.cex}{Numeric, the size of text on the plot.
Use the size rule of \code{ggplot2::geom_text()}.}

\item{x.angle}{Numeric, angle of x axis, in the range of
\eqn{0} to \eqn{360}.}

\item{x.hjust}{Numeric, horizontal justification of x axis,
in the range of \eqn{0} to \eqn{1}.}

\item{title}{Character, the plot title.}

\item{color.set}{A vector of characters, indicating the set of colors to use.
The colors are represented by hexadecimal color code.}
}
\value{
A \code{ggplot} object.
}
\description{
This function draws a partitioned variance plot explained
by different sources.
}
\examples{
if (requireNamespace("vegan", quietly = TRUE) &&
    requireNamespace("SummarizedExperiment", quietly = TRUE)) {
    ## First example
    data("AD_data")
    # centered log ratio transformed data
    ad.clr <- SummarizedExperiment::assays(AD_data$EgData)$Clr_value
    ad.batch <- SummarizedExperiment::rowData(AD_data$EgData)$Y.bat # batch information
    ad.trt <- SummarizedExperiment::rowData(AD_data$EgData)$Y.trt # treatment information
    names(ad.batch) <- names(ad.trt) <- rownames(AD_data$EgData)

    ad.factors.df <- data.frame(trt = ad.trt, batch = ad.batch)
    rda.res <- vegan::varpart(ad.clr, ~trt, ~batch,
        data = ad.factors.df, scale = TRUE
    )

    ad.prop.df <- data.frame(
        Treatment = NA, Batch = NA,
        Intersection = NA,
        Residuals = NA
    )
    ad.prop.df[1, ] <- rda.res$part$indfract$Adj.R.squared

    ad.prop.df <- ad.prop.df[, c(1, 3, 2, 4)]

    partVar_plot(prop.df = ad.prop.df)

    ## Second example
    # a list of data corrected from different methods
    ad.corrected.list <- SummarizedExperiment::assays(AD_data$CorrectData)
    ad.prop.df <- data.frame(
        Treatment = NA, Batch = NA,
        Intersection = NA,
        Residuals = NA
    )
    for (i in seq_len(length(ad.corrected.list))) {
        rda.res <- vegan::varpart(ad.corrected.list[[i]], ~trt, ~batch,
            data = ad.factors.df, scale = TRUE
        )
        ad.prop.df[i, ] <- rda.res$part$indfract$Adj.R.squared
    }

    rownames(ad.prop.df) <- names(ad.corrected.list)

    ad.prop.df <- ad.prop.df[, c(1, 3, 2, 4)]

    partVar_plot(prop.df = ad.prop.df)
}

}
\seealso{
\code{\link{Scatter_Density}}, \code{\link{box_plot}},
\code{\link{density_plot}} and \code{\link{alignment_score}} as the other
methods for batch effect detection and batch effect removal assessment.
}
\author{
Yiwen Wang, Kim-Anh Le Cao
}
