% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockData.R
\docType{methods}
\name{mockQTLE}
\alias{mockQTLE}
\alias{mockSummaryStats}
\alias{mockMASHR}
\alias{mockMASHR_FIT}
\title{Mock data for the QTLExperiment object}
\usage{
mockQTLE(nStates = 10, nQTL = 100, names = TRUE)

mockSummaryStats(nStates = 10, nQTL = 100, names = TRUE)

mockMASHR(nStates = 10, nQTL = 100)

mockMASHR_FIT(nStates = 10, nQTL = 100)
}
\arguments{
\item{nStates}{Number of states}

\item{nQTL}{Number of QTL associations}

\item{names}{Logical to include column and row names}
}
\value{
an object containing simulated data.
}
\description{
Functions to create fake input data for QTLExperiments.
Note that this data is generated simply, and does not have consistency between 
betas, errors and p-values. 
It is helpful to populate the slots of a QTLExperiment object and has expected 
properties of the betas, errors and p-values assays.
Namely, betas are symmetric (specifically normally distributed), errors are 
non-negative, and p-values consist of a null and significant distribution. 
The significant effects make up 10% of the p-values and are randomly distributed 
across states and tests. 

Feature IDs are simulated by randomly selecting a feature from the list 
c("geneA", "geneB", "geneC") with replacement. Variant IDs are created by 
concatenating the string "snp" with a random number in the range 1000:100000.
Row names combine the feature and variant IDs using a vertical line as the 
separator.
}
\examples{
nStates <- 6
nQTL <- 40

# Mock QTLExperiment data

qtle <- mockQTLE(nStates, nQTL)
dim(qtle)

mock_summary_stats <- mockSummaryStats(nStates=nStates, nQTL=nQTL)
mock_summary_stats$betas
mock_summary_stats$errors
mock_summary_stats$pvalues

# Mock MASHR data

mockr_sim <- mockMASHR(nStates=nStates, nQTL=nQTL)
mockr_sim$B
mockr_sim$Bhat
mockr_sim$Shat

}
\author{
Christina B Azodi, Amelia Dunstone
}
