% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-validation.R
\name{dot_test}
\alias{dot_test}
\alias{.test_RequiredColumnsPresent}
\alias{.test_ListRequiredColumnsPresent}
\alias{.test_AllowedColumnsPresent}
\alias{.test_ListAllowedColumnsPresent}
\alias{.test_NoMergeColumn}
\alias{.test_AtLeastOneColumnPresent}
\alias{.test_AtLeastOneElementPresent}
\alias{.test_OneNodePresent}
\alias{.test_IsUnique}
\alias{.test_ListAllUnique}
\alias{.test_IsUniqueInLists}
\alias{.test_ListAllUniqueInLists}
\alias{.test_IsLogical}
\alias{.test_IsNumeric}
\alias{.test_ElementIsNumeric}
\alias{.test_IsCharacter}
\alias{.test_ListAllCharacter}
\alias{.test_IsList}
\alias{.test_ElementIsList}
\alias{.test_IsPos}
\alias{.test_IsClass}
\alias{.test_IsNamedList}
\alias{.test_IsCVPclass}
\alias{.test_ListOfCVPclass}
\alias{.test_ContainsNA}
\alias{.test_ListAllContainsNA}
\alias{.test_ListAllNumeric}
\alias{.test_ListAllNumericOrInDict}
\alias{.test_ListAllOfClass}
\alias{.test_AspectExist}
\alias{.test_IdsInAspect}
\alias{.test_ValuesInSet}
\alias{.test_DataTypeColumn}
\title{Helping tests}
\usage{
.test_RequiredColumnsPresent(aspect, columns, verbose = FALSE)

.test_ListRequiredColumnsPresent(aspect, columns, verbose = FALSE)

.test_AllowedColumnsPresent(aspect, columns, verbose = FALSE)

.test_ListAllowedColumnsPresent(aspect, columns, verbose = FALSE)

.test_NoMergeColumn(aspect, column, verbose = FALSE)

.test_AtLeastOneColumnPresent(aspect, columns, verbose = FALSE)

.test_AtLeastOneElementPresent(aspect, element, verbose = FALSE)

.test_OneNodePresent(nodesAspect, column, verbose = FALSE)

.test_IsUnique(aspect, column, verbose = FALSE)

.test_ListAllUnique(aspect, column, verbose = FALSE)

.test_IsUniqueInLists(aspect, column, verbose = FALSE)

.test_ListAllUniqueInLists(aspect, column, verbose = FALSE)

.test_IsLogical(aspect, column, verbose = FALSE)

.test_IsNumeric(aspect, column, verbose = FALSE)

.test_ElementIsNumeric(aspect, element, verbose = FALSE)

.test_IsCharacter(aspect, column, verbose = FALSE)

.test_ListAllCharacter(aspect, element, verbose = FALSE)

.test_IsList(aspect, column, verbose = FALSE)

.test_ElementIsList(aspect, element, verbose = FALSE)

.test_IsPos(aspect, column, verbose = FALSE)

.test_IsClass(x, cls, verbose = FALSE)

.test_IsNamedList(aspect, names, verbose = FALSE)

.test_IsCVPclass(x, cls, verbose = FALSE)

.test_ListOfCVPclass(x, cls, verbose = FALSE)

.test_ContainsNA(aspect, column, verbose = FALSE)

.test_ListAllContainsNA(aspect, element, verbose = FALSE)

.test_ListAllNumeric(aspect, column, verbose = FALSE)

.test_ListAllNumericOrInDict(aspect, column, dic, verbose = FALSE)

.test_ListAllOfClass(aspect, cls, verbose = FALSE)

.test_AspectExist(rcx, aspect, verbose = FALSE)

.test_IdsInAspect(ids, aspect, column, info = "", verbose = FALSE)

.test_ValuesInSet(aspect, column, set, ignoreNA = TRUE, verbose = FALSE)

.test_DataTypeColumn(aspect, column, verbose = FALSE)
}
\arguments{
\item{aspect}{one RCX aspect}

\item{columns}{character; list of columns}

\item{verbose}{logical (default=FALSE); also log the results}

\item{column}{character; column name}

\item{cls}{character; class name in .CLS or .CLSvp}

\item{names}{character; names of list}

\item{dic}{character; key in .DICT}

\item{rcx}{RCX object}

\item{ids}{numeric; ids}

\item{info}{character (default=""); additional message for verbose}

\item{ignoreNA}{logical (default=TRUE); ignore NA values}
}
\value{
logical; pass or fail the test
}
\description{
Tests for validating RCX objects and its aspects.
}
\section{Functions}{
\itemize{
\item \code{.test_RequiredColumnsPresent()}: checks if aspect has all required columns

\item \code{.test_ListRequiredColumnsPresent()}: checks if all list elements have all required columns

\item \code{.test_AllowedColumnsPresent()}: checks if only allowed columns are set

\item \code{.test_ListAllowedColumnsPresent()}: checks if all list elements have only allowed columns

\item \code{.test_NoMergeColumn()}: checks if column with old ids is not present (would be a merge artefact)

\item \code{.test_AtLeastOneColumnPresent()}: checks if at least one specified column is present

\item \code{.test_AtLeastOneElementPresent()}: checks if at least one specified element is present

\item \code{.test_OneNodePresent()}: checks if at least one element (node) is present in the specified column

\item \code{.test_IsUnique()}: checks if all elements in specified column are unique

\item \code{.test_ListAllUnique()}: checks for all list elements if all elements in specified column are unique

\item \code{.test_IsUniqueInLists()}: checks if all elements in specified column are unique

\item \code{.test_ListAllUniqueInLists()}: checks if all elements in specified column are unique

\item \code{.test_IsLogical()}: checks if the specified column is of type logical

\item \code{.test_IsNumeric()}: checks if the specified column is of type numeric

\item \code{.test_ElementIsNumeric()}: checks if the specified column is of type numeric

\item \code{.test_IsCharacter()}: checks if the specified column is of type character

\item \code{.test_ListAllCharacter()}: checks if the specified list element are all of type character

\item \code{.test_IsList()}: checks if the specified column is of type list

\item \code{.test_ElementIsList()}: checks if the specified column is of type list

\item \code{.test_IsPos()}: checks if the specified column are positive integers

\item \code{.test_IsClass()}: checks if the specified column is of the specified class in .CLS

\item \code{.test_IsNamedList()}: checks if the aspect is a list with specified names

\item \code{.test_IsCVPclass()}: checks if the specified column is of the specified class in .CLSvp

\item \code{.test_ListOfCVPclass()}: checks if the all elements in the list are of class in .CLSvp

\item \code{.test_ContainsNA()}: checks if the specified column contains any NA values

\item \code{.test_ListAllContainsNA()}: checks if the specified list element contains any NA values

\item \code{.test_ListAllNumeric()}: checks if the specified column is a list with only numeric values (NAs and NULLs are not considered)

\item \code{.test_ListAllNumericOrInDict()}: checks if the specified column is a list with only numeric values (NAs and NULLs are not considered) or in .DICT

\item \code{.test_ListAllOfClass()}: checks if the specified column is a list with only numeric values (NAs and NULLs are not considered) or in .DICT

\item \code{.test_AspectExist()}: checks if the rcx object contains the specified apsect

\item \code{.test_IdsInAspect()}: checks if all provided ids are present in the specified column of an aspect

\item \code{.test_ValuesInSet()}: checks if the specified column of an aspect only contains values of the provided set

\item \code{.test_DataTypeColumn()}: checks if the \code{dataType} column of an aspect only contains JSON data types.

}}
\note{
Internal function only for convenience
}
\keyword{internal}
