% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-VisualProperties.R
\name{updateCyVisualProperties}
\alias{updateCyVisualProperties}
\alias{updateCyVisualProperties.CyVisualPropertiesAspect}
\alias{updateCyVisualProperties.RCX}
\title{Update Cytoscape Visual Properties (aspect)}
\usage{
updateCyVisualProperties(
  x,
  cyVisualProperties,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  ...
)

\method{updateCyVisualProperties}{CyVisualPropertiesAspect}(
  x,
  cyVisualProperties,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  ...
)

\method{updateCyVisualProperties}{RCX}(
  x,
  cyVisualProperties,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  checkReferences = TRUE,
  ...
)
}
\arguments{
\item{x}{\link[=RCX-object]{RCX} or \code{\link{CyVisualProperties}} object; (to which it will be added)}

\item{cyVisualProperties}{\code{\link{CyVisualProperties}} object; (that will be added)}

\item{replace}{logical; if existing values are updated (or ignored)}

\item{stopOnDuplicates}{logical; whether to stop, if duplicates in \code{name} (and \code{subnetworkId} if present) column are found}

\item{...}{additional parameters}

\item{checkReferences}{logical; whether to check if references to other aspects are present in the \link[=RCX-object]{RCX} object}
}
\value{
\code{\link{CyVisualProperties}} or \link[=RCX-object]{RCX} object with added Cytoscape visual properties
}
\description{
This function is used to add \link[=CyVisualProperties]{Cytoscape visual properties} aspects to each other or to an
\link[=RCX-object]{RCX} object.
In a \code{\link{CyVisualProperties}} aspect, \code{\link{CyVisualProperty}} objects define networks, nodes, edges, and
default nodes and edges.
}
\details{
\subsection{Structure of Cytoscape Visual Property}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{CyVisualProperty
|---properties = CyVisualPropertyProperties
|   |--name
|   |--value 
|---dependencies = CyVisualPropertyDependencies
|   |--name
|   |--value 
|---mappings = CyVisualPropertyMappings
|   |--name
|   |--type
|   |--definition 
|---appliesTo = <reference to subnetwork id>
|---view = <reference to subnetwork id>
}\if{html}{\out{</div>}}
}

\code{\link{CyVisualProperties}} aspects consist of \code{\link{CyVisualProperty}} objects for each entry: networks, nodes, edges, and
default nodes and edges. Two \code{\link{CyVisualProperties}} aspects are merged by adding its entries individually.

\code{\link{CyVisualProperty}} objects differ in the sub-networks and views (\code{\link{CySubNetworks}}) they apply to,
subsequently properties, dependencies and mappings are merged based on the uniqueness in those two.

Properties, dependencies and mappings (i.e. \code{\link{CyVisualPropertyProperties}}, \code{\link{CyVisualPropertyDependencies}} and
\code{\link{CyVisualPropertyMappings}} objects) are unique in \code{name}.
By default, the duplicate attributes are updated with the values of the latest one.
This can prevented by setting the \emph{replace} parameter to \code{FALSE}, in that case only new attributes are added and
the existing attributes remain untouched.
Furthermore, if duplicated attributes are considered as a preventable mistake, an error can be raised by setting \emph{stopOnDuplicates}
to \code{TRUE}. This forces the function to stop and raise an error, if duplicated attributes are present.
}
\examples{
## Prepare used properties
## Visual property: Properties
vpPropertyP1 = createCyVisualPropertyProperties(c(NODE_BORDER_STROKE="SOLID"))
vpPropertyP2 = createCyVisualPropertyProperties(c(NODE_BORDER_WIDTH="1.5"))
vpPropertyP3 = createCyVisualPropertyProperties(c(NODE_BORDER_WIDTH="999"))

## Visual property: Dependencies
vpPropertyD1 = createCyVisualPropertyDependencies(c(nodeSizeLocked="false"))
vpPropertyD2 = createCyVisualPropertyDependencies(c(arrowColorMatchesEdge="true"))
vpPropertyD3 = createCyVisualPropertyDependencies(c(arrowColorMatchesEdge="false"))

## Visual property: Mappings
vpPropertyM1 = createCyVisualPropertyMappings(c(NODE_FILL_COLOR="CONTINUOUS"), 
                                              "COL=directed,T=boolean,K=0=true,V=0=ARROW")
vpPropertyM2 = createCyVisualPropertyMappings(c(EDGE_TARGET_ARROW_SHAPE="DISCRETE"), 
                                              "TRIANGLE")
vpPropertyM3 = createCyVisualPropertyMappings(c(EDGE_TARGET_ARROW_SHAPE="DISCRETE"), 
                                              "NONE")

## Create visual property object 
vpProperty1 = createCyVisualProperty(properties=list(vpPropertyP1,
                                                     vpPropertyP1), 
                                     dependencies=list(vpPropertyD1,
                                                       NA), 
                                     mappings=list(vpPropertyM1,
                                                   NA),
                                     appliesTo = c(NA,
                                                   1),
                                     view = c(NA,
                                              1))
vpProperty2 = createCyVisualProperty(properties=vpPropertyP2, 
                                     dependencies=vpPropertyD2, 
                                     mappings=vpPropertyM2)
vpProperty3 = createCyVisualProperty(properties=vpPropertyP3, 
                                     dependencies=vpPropertyD3, 
                                     mappings=vpPropertyM3)

## Create a visual properties aspect
## (using the same visual property object for simplicity)
visProp1 = createCyVisualProperties(network=vpProperty1, 
                                    nodes=vpProperty1, 
                                    edges=vpProperty1, 
                                    defaultNodes=vpProperty1, 
                                    defaultEdges=vpProperty1)

visProp2 = createCyVisualProperties(network=vpProperty2, 
                                    nodes=vpProperty2, 
                                    edges=vpProperty2, 
                                    defaultNodes=vpProperty2, 
                                    defaultEdges=vpProperty2)

visProp3 = createCyVisualProperties(network=vpProperty3, 
                                    nodes=vpProperty3, 
                                    edges=vpProperty3, 
                                    defaultNodes=vpProperty3, 
                                    defaultEdges=vpProperty3)

## Adding a different visual property (Properties, Dependencies, Mappings)
## (e.g. "NODE_BORDER_WIDTH", which is not present before)
visProp4 = updateCyVisualProperties(visProp1, visProp2)

## Update a existing visual property
visProp5 = updateCyVisualProperties(visProp4, visProp3)

## Raise an error if duplicate keys are present
try(updateCyVisualProperties(visProp4, visProp3,
                             stopOnDuplicates=TRUE))
## =>ERROR:
##   Elements of name (in VisualProperties$network$properties<appliesTo=NA,view=NA>) 
##   must not contain duplicates!

## For RCX
## prepare RCX object:
nodes = createNodes(name = c("a","b","c","d","e","f"))
edges = createEdges(source=c(1,2,0,0,0,2), 
                    target=c(2,3,1,2,5,4))
rcx = createRCX(nodes, edges)
cySubNetworks = createCySubNetworks(
  id = c(1,2),
  nodes = list("all", c(1,2,3)),
  edges = list("all", c(0,2))                    
)
rcx = updateCySubNetworks(rcx, cySubNetworks)

## Adding visual properties to an RCX object
rcx = updateCyVisualProperties(rcx, visProp1)

## Adding a different visual property (Properties, Dependencies, Mappings)
## (e.g. "NODE_BORDER_WIDTH", which is not present before)
rcx = updateCyVisualProperties(rcx, visProp2)

## Update a existing visual property
rcx = updateCyVisualProperties(rcx, visProp3)

## Raise an error if duplicate keys are present
try(updateCyVisualProperties(rcx, visProp3,
                             stopOnDuplicates=TRUE))
## =>ERROR:
## Elements of "name" (in VisualProperties$network$properties<appliesTo=NA,view=NA>) 
## must not contain duplicates! 
}
\seealso{
\code{\link{updateCyVisualProperty}}, \code{\link{getCyVisualProperty}}
}
