% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Study.R
\name{getStudiesWithSpecificDomainData}
\alias{getStudiesWithSpecificDomainData}
\title{Get a list of studies that have specific domain data}
\usage{
getStudiesWithSpecificDomainData(domain, all_study_ids = c("ALL"))
}
\arguments{
\item{domain}{Name of a specific domain}

\item{all_study_ids}{List of study indentifiers to search on}
}
\value{
List of study indentifiers
}
\description{
Get a list of studies that have specific domain data
}
\examples{
library(DBI)
library(sqldf)
studies_dir <- system.file("extdata", "ImmPortStudies", package = "RImmPort")
db_dir <- file.path(studies_dir, "Db")
sqlite_conn <- dbConnect(SQLite(), dbname=file.path(db_dir, "ImmPort.sqlite"))
setImmPortDataSource(sqlite_conn)
study_ids <- getStudiesWithSpecificDomainData("Demographics")
}

