% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{tnsPlotCoxInteraction,TNS-method}
\alias{tnsPlotCoxInteraction,TNS-method}
\alias{tnsPlotCoxInteraction}
\title{Plot results from Cox regression analysis for dual regulons}
\usage{
\S4method{tnsPlotCoxInteraction}{TNS}(
  tns,
  dualreg,
  xlim = NULL,
  ylim = NULL,
  hlim = NULL,
  hcols = c("#008080ff", "#d45500ff"),
  colorPalette = "bluered",
  fname = "coxInteraction",
  fpath = ".",
  width = 4.5,
  height = 4,
  plotype = "p1",
  plotpdf = FALSE
)
}
\arguments{
\item{tns}{A `TNS` object with regulons used to compute the dual regulon.}

\item{dualreg}{A character string with the name of a dual regulon.}

\item{xlim}{A numeric vector of length 2, i.e. xlim = c(x1, x2),
indicating the limits of the plot for the first member of the dual regulon. 
If xlim = NULL, it will be derevided from the observed data ranges. 
Values must be in the range [-2,2].}

\item{ylim}{A numeric vector of length 2, i.e. ylim = c(y1, y2),
indicating the limits of the plot for the second member of the dual regulon. 
If ylim = NULL, it will be derevided from the observed data ranges. 
Values must be in the range [-2,2]. If plotype='2D', ylim represents the 
two fixed values for the second member of the dual regulon.}

\item{hlim}{A numeric vector of length 2, i.e. hlim = c(h1, h2), 
indicating the limits of the plot for the Hazard Ratio (HR).
If hlim = NULL, it will be derevided from the observed data ranges.
If plotype='2D', HR is represented in the y-axis.}

\item{hcols}{A vector of length 2 indicating a diverging color scheme for 
the Hazard Ratio (HR).}

\item{colorPalette}{A string, which can be 'red', 'blue', 'redblue', or 'bluered'. 
Alternatively, it can be a vector of five colors or hex values.}

\item{fname}{A string. The name of the PDF file (when plotpdf=TRUE).}

\item{fpath}{A string. The directory where the file will be saved.}

\item{width}{A numeric value. The width of the plot.}

\item{height}{A numeric value. The height of the plot.}

\item{plotype}{A string indicating a plot type (options: 'p1', 'p2', 'p3'). 
Plot types 'p1' and 'p2' will show HR on the y-axis, while 'p3' will show 
HR on a color space.}

\item{plotpdf}{A logical value.}
}
\value{
A Cox hazard model plot and statistics.

A 3D heatmap plot.
}
\description{
Plot results from Cox regression analysis for dual regulons
}
\examples{
# load survival data
data(survival.data, package = "RTNsurvival")

# load TNI-object
data(stni, package = "RTN")

# perform survival analysis for regulons
stns <- tni2tnsPreprocess(stni, survivalData = survival.data, time = 1, event = 2)
stns <- tnsGSEA2(stns, verbose=FALSE)

# run Cox regression for dual regulons
# stns <- tnsCoxInteraction(stns, stepFilter = FALSE)
# tnsPlotCoxInteraction(stns, dualreg = "FOXM1~PTTG1")
}
\seealso{
\code{\link{tnsKM}},
\code{\link{tnsCox}}
}
