% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_accessors.R
\docType{methods}
\name{model_list}
\alias{model_list}
\alias{model_list,siamcat-method}
\title{Retrieve the information stored in the \code{model_list} slot within
a SIAMCAT object}
\usage{
model_list(siamcat, verbose=1)

\S4method{model_list}{siamcat}(siamcat, verbose = 1)
}
\arguments{
\item{siamcat}{(Required). An instance of \link{siamcat-class}
that contains trained models}

\item{verbose}{integer, if the slot is empty, should a message be printed?
values can be either \code{0} (no output) or \code{1} (print message)}
}
\value{
The list stored in the \code{model_list} slot of the SIAMCAT object
or \code{NULL}
}
\description{
Function to retrieve the information stored in the
\code{model_list} slot within a SIAMCAT object
}
\details{
The function will return a list containing the information stored
in the \code{model_list} slot of a SIAMCAT object. This list contains:
\itemize{
\item \code{models} - list of trained models
\item \code{model_type} - machine learning method used for training
\item \code{feature_type} - string describing on which type of features the
models were trained
}
}
\examples{
data(siamcat_example)
temp <- model_list(siamcat_example)
names(temp)
}
\keyword{internal}
