% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_accessors.R
\docType{methods}
\name{norm_feat}
\alias{norm_feat}
\alias{norm_feat,siamcat-method}
\title{Retrieve the information stored in the \code{norm_feat} slot within
a SIAMCAT object}
\usage{
norm_feat(siamcat, verbose=1)

\S4method{norm_feat}{siamcat}(siamcat, verbose = 1)
}
\arguments{
\item{siamcat}{(Required). An instance of \link{siamcat-class}
that contains normalized features}

\item{verbose}{integer, if the slot is empty, should a message be printed?
values can be either \code{0} (no output) or \code{1} (print message)}
}
\value{
The list stored in the \code{norm_feat} slot of the SIAMCAT object
or \code{NULL}
}
\description{
Function to retrieve the information stored in the
\code{norm_feat} slot within a SIAMCAT object
}
\details{
The function will return a list containing the information stored
in the \code{norm_feat} slot of a SIAMCAT object. This list contains:
\itemize{
\item \code{norm.feat} - normalized features as matrix, see
\link{get.norm_feat.matrix}
\item \code{norm.param} - parameters used for normalization, see
\link{normalize.features}
}
}
\examples{
data(siamcat_example)
temp <- norm_feat(siamcat_example)
names(temp)
}
\keyword{internal}
