% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_features.r
\encoding{UTF-8}
\name{normalize.features}
\alias{normalize.features}
\title{Perform feature normalization}
\usage{
normalize.features(siamcat, norm.method = c("rank.unit", "rank.std",
"log.std", "log.unit", "log.clr", "std", "pass"), 
norm.param = list(log.n0 = 1e-06, sd.min.q = 0.1, n.p = 2, norm.margin = 1),
feature.type='filtered', verbose = 1)
}
\arguments{
\item{siamcat}{an object of class \link{siamcat-class}}

\item{norm.method}{string, normalization method, can be one of these:
\code{c('rank.unit', 'rank.std', 'log.std', 'log.unit', 'log.clr','std', 
'pass')}}

\item{norm.param}{list, specifying the parameters of the different 
normalization methods, see Details for more information}

\item{feature.type}{string, on which type of features should the function
work? Can be either \code{"original"}, \code{"filtered"}, or
\code{"normalized"}. Please only change this paramter if you know what
you are doing!}

\item{verbose}{integer, control output: \code{0} for no output at all,
\code{1} for only information about progress and success, \code{2} for
normal level of information and \code{3} for full debug information,
defaults to \code{1}}
}
\value{
an object of class \link{siamcat-class} with normalized features
}
\description{
This function performs feature normalization according to 
user-specified parameters.
}
\section{Implemented methods}{

There are seven different normalization methods available, which 
might need additional parameters, which are passed via the \code{norm.param}
list:
\itemize{
\item \code{'rank.unit'} - converts features to ranks and normalizes 
each column (=sample) by the square root of the sum of ranks
This method does not require additional parameters.
\item \code{'rank.std'} - converts features to ranks and applies z-score 
standardization. 
This method requires \code{sd.min.q} (minimum quantile of the standard 
deviation to be added to all features in order to avoid underestimation of 
standard deviation) as additional parameter.
\item \code{'log.clr'} - centered log-ratio transformation.
This methods requires a pseudocount (\code{log.n0}) before 
log-transformation.
\item \code{'log.std'} - log-transforms features and applies z-score 
standardization.
This method requires both a pseudocount (\code{log.n0}) and \code{sd.min.q}
\item \code{'log.unit'} - log-transforms features and normalizes by 
features or samples with different norms.
This method requires a pseudocount (\code{log.n0}) and then additionally the
parameters \code{norm.maring} (margin over which to normalize, similarly to 
the \code{apply}-syntax: Allowed values are \code{1} for normalization 
over features, \code{2} over samples, and \code{3} for normalization 
by the global maximum) and the parameter \code{n.p} (vector norm to be 
used, can be either \code{1} for \code{x/sum(x)} or \code{2} for 
\code{x/sqrt(sum(x^2))}).
\item \code{'std'} - z-score standardization without any other 
transformation
This method only requires the \code{sd.min.q} parameter
\item \code{'pass'} - pass-through normalization will not change 
the features}
}

\section{Frozen normalization}{

The function additionally allows to perform a frozen normalization on a
different dataset. After normalizing the first dataset, the \code{norm_feat}
slot in the SIAMCAT object contains all parameters of the normalization,
which you can access via the \link{norm_params} accessor.

In order to perform a frozen normalization of a new dataset, you can run the
function supplying the normalization parameters as argument to
\code{norm.param}:
\code{norm.param=norm_params(siamcat_reference)}. See also the example below.
}

\examples{
# Example data
data(siamcat_example)

# Simple example
siamcat_norm <- normalize.features(siamcat_example,
    norm.method='rank.unit')

# log.unit example
siamcat_norm <- normalize.features(siamcat_example,
    norm.method='log.unit',
    norm.param=list(log.n0=1e-05, n.p=1, norm.margin=1))

# log.std example
siamcat_norm <- normalize.features(siamcat_example,
    norm.method='log.std',
    norm.param=list(log.n0=1e-05, sd.min.q=.1))

# Frozen normalization
# normalize the object siamcat with the same parameters as used in 
# siamcat_reference
# 
# this is not run
# siamcat_norm <- normalize.features(siamcat,
#   norm.param=norm_params(siamcat_reference))
}
\keyword{SIAMCAT}
\keyword{normalize.features}
