% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert4pythonscript.R
\name{convert4pythonscript}
\alias{convert4pythonscript}
\title{Convert data into the format for running a python script.}
\usage{
convert4pythonscript(data, replace.Unimod = TRUE)
}
\arguments{
\item{data}{A data frame containing SWATH data.}

\item{replace.Unimod}{Option to indicate if Unimod Identifier should be
replaced form ":"" to "_".}
}
\value{
Returns a data frame in the appropriate format to be used by a custom
  python script stored in the scripts folder.
}
\description{
This functions selects the columns suggested to run a python script to change
the data from peptide-level to transition-level.
}
\details{
The necessary columns are selected and the run column is renamed to filename
for the script. The intensities are taken from the column aggr_Peak_Area and
therefore the Intensity column is not exported.
}
\examples{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 data.filtered.decoy <- filter_mscore(data,0.01)
 data.pythonscript <- convert4pythonscript(data.filtered.decoy)
}
\author{
Peter Blattmann
}
