% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialExperiment-combine.R
\name{SpatialExperiment-combine}
\alias{SpatialExperiment-combine}
\alias{cbind,SingleCellExperiment-method}
\alias{cbind,SpatialExperiment-method}
\title{Combining SpatialExperiment objects}
\usage{
\S4method{cbind}{SpatialExperiment}(..., deparse.level = 1)
}
\arguments{
\item{...}{a list of \code{\link{SpatialExperiment}} objects}

\item{deparse.level}{refer to \code{?\link[base]{rbind}}}
}
\value{
a combined \code{\link{SpatialExperiment}} object
}
\description{
The \code{\link{SpatialExperiment}} class provides modified methods to
combine multiple \code{SpatialExperiment} objects by column, for example from
multiple samples. These methods ensure that all data fields remain
synchronized when samples are added or removed.
}
\section{Combining}{

The \code{...} argument is assumed to contain one or more
\code{\link{SpatialExperiment}} objects.

\describe{
\item{\code{cbind(..., deparse.level=1)}:}{ 
Returns a \code{SpatialExperiment} where all objects in \code{...} are
combined column-wise, i.e., columns in successive objects are appended to the
first object.

Each \code{SpatialExperiment} object in \code{...} must have the same
\code{colData} (with the same \code{\link{spatialCoords}}). If multiple
objects use the same \code{sample_id}, the method will proceed by assigning
unique \code{sample_id}s.

Additionally, the method combines \code{imgData} by row using \code{rbind}.

Refer to \code{?"\link{cbind,SingleCellExperiment-method}"} for details on
how metadata and other inherited attributes are combined in the output
object.

Refer to \code{?\link[base]{cbind}} for the interpretation of
\code{deparse.level}.
}
}
}

\examples{
example(SpatialExperiment)

# merging with duplicated 'sample_id's
# will automatically assign unique identifiers
spe1 <- spe2 <- spe
spe3 <- cbind(spe1, spe2)
unique(spe3$sample_id)

# assign unique sample identifiers
spe1 <- spe2 <- spe
spe1$sample_id <- paste(spe1$sample_id, "sample1", sep = ".")
spe2$sample_id <- paste(spe2$sample_id, "sample2", sep = ".")

# combine into single object
spe <- cbind(spe1, spe2)

# view joint 'imgData'
imgData(spe)

# tabulate number of spots mapped to tissue
cd <- colData(spe)
table(
  in_tissue = cd$in_tissue, 
  sample_id = cd$sample_id)
}
\author{
Dario Righelli
}
