% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tapseq_input.R
\name{createIORecord}
\alias{createIORecord}
\alias{createIORecord,TsIO-method}
\alias{createIORecord,TsIOList-method}
\title{Create boulder IO record}
\usage{
createIORecord(object, thermo_params_path = NA)

\S4method{createIORecord}{TsIO}(object, thermo_params_path = NA)

\S4method{createIORecord}{TsIOList}(object, thermo_params_path = NA)
}
\arguments{
\item{object}{TsIO of TsIOList object for which a Primer3 boulder IO record should be created.}

\item{thermo_params_path}{Optional path (character) to the \code{primer3_config} directory. Only
required when using Primer3 < 2.5.0.}
}
\value{
A character vector containing the lines of the IO record.
}
\description{
Takes a \code{\link[TAPseq:TsIO-class]{TsIO}} or \code{\link[TAPseq:TsIOList-class]{TsIOList}}
object and converts it into a boulder IO record for Primer3. Essentially it converts it into a
list of character vectors that each contain the tag and the value in the form: "TAG=VALUE". More
on this format can be found in the \href{http://primer3.org/manual.html}{Primer3 manual}.
}
\details{
This function is usually not needed by the user, because functions such as
\code{\link[TAPseq]{designPrimers}} handle IO record generation. However, this function can for
instance be useful to generate IO records, write them to a file and pass them to Primer3 in the
conventional way.
}
\section{Methods (by class)}{
\itemize{
\item \code{createIORecord(TsIO)}: Create IO record from \code{TsIO} objects.

\item \code{createIORecord(TsIOList)}: Create IO record from \code{TsIO} objects.

}}
\examples{
# chromosome 11 truncated transcript sequences
data("chr11_truncated_txs_seq")

# create TsIOList object for primer desing from sequence templates
obj <- TAPseqInput(chr11_truncated_txs_seq, product_size_range = c(350, 500))

# create boulder IO record
boulder_io <- createIORecord(obj)
head(boulder_io, 11)
}
\seealso{
\url{http://primer3.org/manual.html} for Primer3 manual.
}
