% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_primers.R
\name{pickPrimers}
\alias{pickPrimers}
\alias{pickPrimers,TsIO-method}
\alias{pickPrimers,TsIOList-method}
\title{Pick best TAP-seq primers}
\usage{
pickPrimers(object, n = 1, by = c("penalty", "off_targets"))

\S4method{pickPrimers}{TsIO}(object, n = 1, by = c("penalty", "off_targets"))

\S4method{pickPrimers}{TsIOList}(object, n = 1, by = c("penalty", "off_targets"))
}
\arguments{
\item{object}{A \code{\link[TAPseq:TsIO-class]{TsIO}} or
\code{\link[TAPseq:TsIOList-class]{TsIOList}} object containing designed primers.}

\item{n}{The number of top primers to pick (default: 1, which returns the best primer).}

\item{by}{Attribute by which primers should be picked. Can be either \code{penalty} or
\code{off_targets}.}
}
\value{
A \code{\link[TAPseq:TsIO-class]{TsIO}} or \code{\link[TAPseq:TsIOList-class]{TsIOList}}
  object containing the picked primers.
}
\description{
Pick based primers from designed primers for every target based on Primer3 penalty score or
off-target priming estimated with \code{\link[TAPseq:estimateOffTargets]{blastPrimers}}.
}
\details{
If \code{by} is set to \code{off_targets} top primers are picked based on the lowest number of
exonic, intronic and intergenic off-targets (in that priority).
}
\section{Methods (by class)}{
\itemize{
\item \code{pickPrimers(TsIO)}: Pick best primers in a \code{TsIO} object

\item \code{pickPrimers(TsIOList)}: Pick best primers per target in a \code{TsIOList} object

}}
\examples{
# chr11 primers examples
data("chr11_primers")

# pick the best primer per gene based on the fewest exonic, intronic and intergenic off-targets
# (in that order)
best_primers <- pickPrimers(chr11_primers, by = "off_targets")
tapseq_primers(best_primers)

# pick the best two primers per gene based on the lowest penalty score computed by Primer3
best_primers <- pickPrimers(chr11_primers, n = 2, by = "penalty")
tapseq_primers(best_primers)
}
