% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenericFunctions.R
\name{TCA.accessors}
\alias{TCA.accessors}
\alias{design}
\alias{design,TCA-method}
\alias{genomicFeature,TCA-method}
\alias{tcTable,TCA-method}
\alias{clustResults,TCA-method}
\alias{genomicFeature}
\alias{tcTable}
\alias{clustResults}
\title{Accessors to extract slots of a TCA class.}
\usage{
\S4method{design}{TCA}(object)

genomicFeature(object)

tcTable(object)

\S4method{tcTable}{TCA}(object)

clustResults(object)

\S4method{clustResults}{TCA}(object)
}
\arguments{
\item{object}{\code{TCA} object object}
}
\value{
\code{design} returns a data frame. \code{genomicFeature} returns a data frame.
\code{tcTable} returns a numeric matrix. \code{clustResults} returns a
\code{clust} object, see \code{\link{clust}} for details.
}
\description{
Accessors are provided to extract \code{design}, \code{genomicFeature},
\code{tcTable}, \code{clustResults} slots of a TCA class. The \code{design}
slot stores experimental information of samples/libraries, the
\code{genomicFeature} slot stores genomic coordinates of features, the
\code{tcTable} slot stores time couse data as a matrix, where rows are
genomic features and columns time points. The \code{clustResults} slot
stores results of clustering analysis as a \code{clust} object.
}
\examples{
data(tca_ATAC)
genomicFeature(tca_ATAC)
tcTable(tca_ATAC)
}
\seealso{
\code{\link{clust}}
}
\author{
Mengjun Wu
}
