% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.R
\name{remove_raw}
\alias{remove_raw}
\title{Remove selected raw curves}
\usage{
remove_raw(raw_data, removerange = NULL, removelist = NULL)
}
\arguments{
\item{raw_data}{dataframe; to be processed data}

\item{removerange}{list type input identifying range of wells to select.
For example, if removing all 12 wells from row D to H is needed, one can
specify the row letters and column numbers like this:
\code{removerange = c("D", "H", "1", "12")}}

\item{removelist}{use this parameter to remove selected Wells with full
Well names. For example, \code{removelist = c('A01', 'D11')}}
}
\value{
dataframe; data frame with specified well removed
}
\description{
Removes selected curves with specified wells and range.
}
\examples{
data("qPCR_data1")
remove_raw(qPCR_data1, removelist = c("A01", "D11"))

}
\seealso{
Other data_preprocess: 
\code{\link{model_boltzmann}()},
\code{\link{model_fit}()},
\code{\link{model_gam}()},
\code{\link{normalize}()},
\code{\link{run_boltzmann}()},
\code{\link{screen}()},
\code{\link{view_model}()},
\code{\link{weed_raw}()}
}
\concept{data_preprocess}
