% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsa_curves.R
\name{TSA_compare_plot}
\alias{TSA_compare_plot}
\title{Compare TSA curves to control}
\usage{
TSA_compare_plot(
  tsa_data,
  control_condition,
  y = "Fluorescence",
  show_Tm = FALSE,
  title_by = "both",
  digits = 1
)
}
\arguments{
\item{tsa_data}{a data frame that is merged and generated by
TSAR::merge_TSA(). If \code{y = 'RFU'}, tsa_data must also be
generated by TSAR::normalize_fluorescence. The Temperature column will be
rounded and the average & sd of each rounded temperature is calculated.}

\item{control_condition}{character string matching a Condition ID. Must be
equal to a value within tsa_data$condition_ID. See unique condition IDs
with \code{\link{condition_IDs}}.}

\item{y}{character string; c('Fluorescence', 'RFU').
When \code{y = 'Fluorescence'}, the original Fluorescence data from
TSAR::read_raw_data() is averaged. When \code{y = 'RFU'}, the average is
calculated by the rescaled fluorescence.}

\item{show_Tm}{logical; \code{show_Tm = FALSE} by default. When TRUE, the Tm
is displayed on the plot. When FALSE, the Tm is not added to the plot.}

\item{title_by}{character string; c("ligand", "protein", "both").
Automatically names the plots by the specified condition category.}

\item{digits}{integer; the number of decimal places to round for change in Tm
calculations displayed in the subtitle of each plot..}
}
\value{
Generates a number of ggplot objects equal to the number of unique
    Condition IDs present in the input data.
}
\description{
Generate a number of plots based on the input data to compare the average
and standard deviation (sd) of each unique condition to a specified
control condition. To see all conditions use \code{condition_IDs(tsa_data)}.
}
\examples{
data("example_tsar_data")
TSA_compare_plot(example_tsar_data,
    y = "RFU",
    control_condition = "CA FL_DMSO"
)
}
\seealso{
\code{\link{merge_TSA}} and \code{\link{normalize_fluorescence}}
    for preparing data. See \code{\link{TSA_average}} and
    \code{\link{get_legend}} for details on function parameters.
    See \code{\link{TSA_wells_plot}} for individual curves of the averaged
    conditions shown.

Other TSA Plots: 
\code{\link{TSA_boxplot}()},
\code{\link{TSA_wells_plot}()},
\code{\link{get_legend}()},
\code{\link{graph_tsar}()},
\code{\link{view_deriv}()}
}
\concept{TSA Plots}
