% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_NCBI_sets.R
\name{get_ncbi_taxon_ids}
\alias{get_ncbi_taxon_ids}
\title{Retrieve NCBI Taxonomy IDs for a list of taxon names}
\usage{
get_ncbi_taxon_ids(taxon_names)
}
\arguments{
\item{taxon_names}{A character vector of taxon names}
}
\value{
A character vector of NCBI taxonomy IDs corresponding to the
input taxon names
}
\description{
This function takes a vector of taxon names and returns a vector of
NCBI taxonomy IDs
by querying the NCBI Entrez API.
}
\examples{
taxon_names <- c("Escherichia coli", "Staphylococcus aureus")
taxon_ids <- get_ncbi_taxon_ids(taxon_names)
}
