% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tail.Venn}
\alias{tail.Venn}
\title{Extract the last few rows of a Venn object}
\usage{
\method{tail}{Venn}(x, n = 6L, ...)
}
\arguments{
\item{x}{A Venn object}

\item{n}{Number of rows to extract}

\item{...}{Additional arguments passed to tail}
}
\value{
A data frame with the last n rows
}
\description{
Extract the last n rows of the result data frame
}
\examples{
# Create a Venn object
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
res <- venndetail(list(A = A, B = B))

# Get the last few rows
tail(res)
}
\author{
Kai Guo
}
