% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_counts.R
\name{scSubjects}
\alias{scSubjects}
\title{SingleCellExperiment subject values}
\usage{
scSubjects(scExp, ...)
}
\arguments{
\item{scExp}{\linkS4class{SingleCellExperiment} object containing
(at minimum) gene counts and column metadata describing sample identifiers
and cell types.}

\item{...}{Named metadata variables for subjects and cell types.}
}
\value{
List of character vectors with unique values from
\linkS4class{SingleCellExperiment} column metadata variables.
}
\description{
Extract unique values from \linkS4class{SingleCellExperiment}
column (i.e. cell) metadata. Used to determine subject and cell type values.
}
\examples{
## Examples of metadata column variable names.
names(SummarizedExperiment::colData(small_airway))

## Return list of subject and cell type values from experiment metadata.
scSubjects(scExp=small_airway, subjects="orig.ident", cellTypes="celltype")

}
