% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alevinQCReport.R
\name{qcReport}
\alias{qcReport}
\alias{alevinQCReport}
\alias{simpleafQCReport}
\alias{alevinFryQCReport}
\title{Generate alevin/alevin-fry summary report}
\usage{
alevinQCReport(
  baseDir,
  sampleId,
  outputFile,
  outputDir = "./",
  outputFormat = NULL,
  showCode = FALSE,
  forceOverwrite = FALSE,
  knitrProgress = FALSE,
  quiet = FALSE,
  ignorePandoc = FALSE,
  customCBList = list(),
  ...
)

simpleafQCReport(
  simpleafQuantDir,
  sampleId,
  outputFile,
  outputDir = "./",
  outputFormat = NULL,
  showCode = FALSE,
  forceOverwrite = FALSE,
  knitrProgress = FALSE,
  quiet = FALSE,
  ignorePandoc = FALSE,
  customCBList = list(),
  ...
)

alevinFryQCReport(
  mapDir,
  permitDir,
  quantDir,
  sampleId,
  outputFile,
  outputDir = "./",
  outputFormat = NULL,
  showCode = FALSE,
  forceOverwrite = FALSE,
  knitrProgress = FALSE,
  quiet = FALSE,
  ignorePandoc = FALSE,
  customCBList = list(),
  ...
)
}
\arguments{
\item{baseDir}{(Only used for alevin output) Path to the output directory
from the alevin run (should be the directory containing the
\code{alevin} directory).}

\item{sampleId}{Sample ID, will be used to set the title for the report.}

\item{outputFile}{File name of the output report. The file name extension
must be either \code{.html} or \code{.pdf}, and consistent with the value
of \code{outputFormat}.}

\item{outputDir}{Path to the output directory where the report will be
generated.}

\item{outputFormat}{The format of the output report. Either
\code{"html_document"}, \code{"pdf_document"},
\code{"BiocStyle::html_document"} or \code{"BiocStyle::pdf_document"}.
The file name extension of \code{outputFile} must be consistent with this
choice.}

\item{showCode}{Logical, whether to display the R code in the report.}

\item{forceOverwrite}{Logical, whether to force overwrite an existing report
with the same name in the output directory.}

\item{knitrProgress}{Logical, whether to display the progress of \code{knitr}
when generating the report.}

\item{quiet}{Logical, whether to show progress messages.}

\item{ignorePandoc}{Logical, determines what to do if \code{pandoc} or
\code{pandoc-citeproc} is missing (if \code{Sys.which("pandoc")} or
\code{Sys.which("pandoc-citeproc")} returns ""). If \code{ignorePandoc}
is TRUE, only a warning is given. The figures will be generated, but not
the final report. If \code{ignorePandoc} is FALSE (default), the
execution stops immediately.}

\item{customCBList}{Named list with custom set(s) of barcodes to provide
summary statistics/plots for, in addition to the whitelists generated by
alevin.}

\item{...}{Other arguments that will be passed to \code{rmarkdown::render}.}

\item{simpleafQuantDir}{(Only used for simpleaf output) Path to the output
directory from the simpleaf run (should be the directory containing the
\code{af_map} and \code{af_quant} directories).}

\item{mapDir}{(Only used for alevin-fry output) Path to the output directory
from the salmon alevin run (should be the directory containing the
\code{map.rad} file).}

\item{permitDir}{(Only used for alevin-fry output) Path to the output
directory from the permit list generation step (should be
the directory containing the \code{all_freq.tsv} file).}

\item{quantDir}{(Only used for alevin-fry output) Path to the output
directory from the alevin-fry quantification step (should be
the directory containing the \code{alevin} directory).}
}
\value{
Generates a summary report in the \code{outputDir} directory, and
    returns (invisibly) the name of the generated report.
}
\description{
Generate a report summarizing the main aspects of an alevin/alevin-fry
quantification run. The report generation assumes that alevin/alevin-fry
has been run with the --dumpFeatures flag to generate the necessary
output files.
}
\details{
When the function is called, a .Rmd template file will be copied
    into the output directory, and \code{rmarkdown::render} will be called to
    generate the final report. If there is already a .Rmd file with the same
    name in the output directory, the function will raise an error and stop,
    to avoid overwriting the existing file. The reason for this behaviour is
    that the copied template in the output directory will be deleted once
    the report is generated.
}
\examples{
alevinQCReport(
    baseDir = system.file("extdata/alevin_example_v0.14",
                          package = "alevinQC"),
    sampleId = "example", outputFile = "alevinReport.html",
    outputDir = tempdir(), forceOverwrite = TRUE)

alevinFryQCReport(
    mapDir = system.file("extdata/alevinfry_example_v0.5.0/map",
                         package = "alevinQC"),
    permitDir = system.file("extdata/alevinfry_example_v0.5.0/permit",
                            package = "alevinQC"),
    quantDir = system.file("extdata/alevinfry_example_v0.5.0/quant",
                           package = "alevinQC"),
    sampleId = "example", outputFile = "alevinFryReport.html",
    outputDir = tempdir(), forceOverwrite = TRUE)

simpleafQCReport(
    simpleafQuantDir = system.file("extdata/alevinfry_example_piscem_v0.6.0",
                                   package = "alevinQC"),
    sampleId = "example", outputFile = "simpleafReport.html",
    outputDir = tempdir(), forceOverwrite = TRUE)

}
\author{
Charlotte Soneson
}
