% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readQueryFile.R
\name{getQueryLoc}
\alias{getQueryLoc}
\title{Find the closest 3' and 5' exons to a branchpointer query}
\usage{
getQueryLoc(query, queryType, maxDist = 50, filter = TRUE, exons)
}
\arguments{
\item{query}{branchpointer query GenomicRanges
must have chromosome at position 2, genomic co-ordinate at position 3,
and strand at position 4.}

\item{queryType}{type of query file (\code{"SNP"} or \code{"region"})}

\item{maxDist}{maximum distance a SNP can be from an annotated 3' exon.}

\item{filter}{remove SNP queries prior to finding finding nearest exons.}

\item{exons}{data.frame containing exon co-ordinates.
Should be produced by gtfToExons()}
}
\value{
GenomicRanges with the query and its location relative to the 3' and 5' exons
}
\description{
Finds the closest annotated exons from genomic co-ordinates in a branchpointer query GRanges
}
\author{
Beth Signal
}
\keyword{internal}
