% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readQueryFile.R
\name{readQueryFile}
\alias{readQueryFile}
\title{Read a query file}
\usage{
readQueryFile(queryFile, queryType, exons, maxDist = 50, filter = TRUE)
}
\arguments{
\item{queryFile}{tab delimited file containing query information.
For intronic regions should be in the format: region id, chromosome name, region start, region end, strand.
For SNP variants should be in the format: SNP id, chromosome name, SNP position, strand, reference allele (A/T/C/G), alternative allele (A/T/C/G)}

\item{queryType}{type of query file (\code{"SNP"} or \code{"region"})}

\item{exons}{GRanges containing exon co-ordinates.
Should be produced by gtfToExons()}

\item{maxDist}{maximum distance a SNP can be from an annotated 3' exon.}

\item{filter}{remove SNP queries prior to finding finding nearest exons.}
}
\value{
Formatted query GRanges
}
\description{
Reads and formats a manually generated query file, and finds realtive locations of the closest annotated exons
Converts unstranded SNPs to two entries for each strand.
Checks for duplicate names and replaces if found.
}
\examples{
smallExons <- system.file("extdata","gencode.v26.annotation.small.gtf", package = "branchpointer")
exons <- gtfToExons(smallExons)

querySNPFile <- system.file("extdata","SNP_example.txt", package = "branchpointer")
querySNP <- readQueryFile(querySNPFile, queryType = "SNP", exons)

queryIntronFile <- system.file("extdata","intron_example.txt", package = "branchpointer")
queryIntron <- readQueryFile(queryIntronFile,queryType = "region", exons)
}
\author{
Beth Signal
}
