% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCicero.R
\name{make_cicero_cds}
\alias{make_cicero_cds}
\title{Create cicero input CDS}
\usage{
make_cicero_cds(
  cds,
  reduced_coordinates,
  k = 50,
  summary_stats = NULL,
  size_factor_normalize = TRUE,
  silent = FALSE,
  return_agg_info = FALSE
)
}
\arguments{
\item{cds}{Input CDS object.}

\item{reduced_coordinates}{A data frame with columns representing the
coordinates of each cell in reduced dimension space (generally 2-3
dimensions). \code{row.names(reduced_coordinates)} should match the cell
names in the CDS object. If dimension reduction was done using monocle,
tSNE coordinates can be accessed by \code{t(reducedDimA(cds))}, and
DDRTree coordinates can be accessed by \code{t(reducedDimS(cds))}.}

\item{k}{Number of cells to aggregate per bin.}

\item{summary_stats}{Which numeric \code{pData(cds)} columns you would like
summarized (mean) by bin in the resulting CDS object.}

\item{size_factor_normalize}{Logical, should accessibility values be
normalized by size factor?}

\item{silent}{Logical, should warning and info messages be printed?}

\item{return_agg_info}{Logical, should a list of the assignments of cells to
aggregated bins be output? When \code{TRUE}, this function returns a list 
of two items, first, the aggregated CDS object and second, a data.frame 
with the binning information.}
}
\value{
Aggregated CDS object. If return_agg_info is \code{TRUE}, a list 
  of the aggregated CDS object and a data.frame of aggregation info.
}
\description{
Function to generate an aggregated input CDS for cicero. \code{run_cicero}
takes as input an aggregated cicero CDS object. This function will generate
the CDS given an input CDS (perhaps generated by  \code{make_atac_cds}) and
a value for k, which is the number of cells to be aggregated per bin. The
default value for k is 50.
}
\details{
Aggregation of similar cells is done using a k-nearest-neighbors
  graph and a randomized "bagging" procedure. Details are available in the
  publication that accompanies this package. Run \code{citation("cicero")}
  for publication details. KNN is calculated using
  \code{\link[FNN]{knn.index}}
}
\examples{
\dontrun{
  data("cicero_data")

  input_cds <- make_atac_cds(cicero_data, binarize = TRUE)
  input_cds <- reduceDimension(input_cds, max_components = 2, num_dim=6,
                               reduction_method = 'tSNE',
                               norm_method = "none")
  tsne_coords <- t(reducedDimA(input_cds))
  row.names(tsne_coords) <- row.names(pData(input_cds))
  cicero_cds <- make_cicero_cds(input_cds, reduced_coordinates = tsne_coords)
}

}
