% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset}
\alias{subset}
\alias{removeClusterings,ClusterExperiment-method}
\alias{removeClusters,ClusterExperiment-method}
\alias{removeClusters}
\alias{[,ClusterExperiment,ANY,character,ANY-method}
\alias{[,ClusterExperiment,ANY,ANY,ANY-method}
\alias{[,ClusterExperiment,ANY,logical,ANY-method}
\alias{[,ClusterExperiment,ANY,numeric,ANY-method}
\alias{subsetByCluster,ClusterExperiment-method}
\alias{subsetByCluster}
\title{Functions to subset ClusterExperiment Objects}
\usage{
\S4method{removeClusterings}{ClusterExperiment}(x, whichClusters)

\S4method{removeClusters}{ClusterExperiment}(
  x,
  whichCluster,
  clustersToRemove,
  makePrimary = FALSE,
  clusterLabels = NULL
)

\S4method{[}{ClusterExperiment,ANY,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{ClusterExperiment,ANY,logical,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{ClusterExperiment,ANY,numeric,ANY}(x, i, j, ..., drop = TRUE)

\S4method{subsetByCluster}{ClusterExperiment}(
  x,
  clusterValue,
  whichCluster = "primary",
  matchTo = c("name", "clusterIds")
)
}
\arguments{
\item{x}{a ClusterExperiment object.}

\item{whichClusters}{argument that can be either numeric or character vector
indicating the clusterings to be used. See details of \code{\link{getClusterIndex}}.}

\item{whichCluster}{argument that can be a single numeric or character value
indicating the \emph{single} clustering to be used. Giving values that result in more than one clustering will result in an error. See details of \code{\link{getClusterIndex}}.}

\item{clustersToRemove}{numeric vector identifying the clusters to remove
(whose samples will be reassigned to -1 value).}

\item{makePrimary}{whether to make the added cluster the primary cluster
(only relevant if \code{y} is a vector)}

\item{clusterLabels}{label(s) for the clusters being added. If \code{y} a
matrix, the column names of that matrix will be used by default, if
\code{clusterLabels} is not given.}

\item{i, j}{A vector of logical or integer subscripts, indicating the rows and columns to be subsetted for \code{i} and \code{j}, respectively.}

\item{...}{The arguments \code{transformation}, \code{clusterTypes} and
\code{clusterInfo} to be passed to the constructor for signature
\code{SingleCellExperiment,matrix}.}

\item{drop}{A logical scalar that is ignored.}

\item{clusterValue}{values of the cluster to match to for subsetting}

\item{matchTo}{whether to match to the cluster name
(\code{"name"}) or internal cluster id (\code{"clusterIds"})}
}
\value{
A \code{\link{ClusterExperiment}} object.

\code{removeClusterings} returns a \code{ClusterExperiment} object,
  unless all clusters are removed, in which case it returns a
  \code{\link{SingleCellExperiment}} object.

\code{subsetByCluster} subsets the object by clusters in a clustering
and returns a ClusterExperiment object with only those samples
}
\description{
These functions are used to subset ClusterExperiment objects,
  either by removing samples, genes, or clusterings
}
\details{
\code{removeClusterings} removes the clusters given by
  \code{whichClusters}. If the \code{primaryCluster} is one of the clusters
  removed, the \code{primaryClusterIndex} is set to 1 and the dendrogram and
  coclustering matrix are discarded and orderSamples is set to
  \code{1:NCOL(x)}.

\code{removeClusters} creates a new cluster that unassigns samples
  in cluster \code{clustersToRemove} (in the clustering defined by
  \code{whichClusters}) and assigns them to -1 (unassigned)

Note that when subsetting the data, the dendrogram information and
the co-clustering matrix are lost.
}
\examples{
#load CE object
data(rsecFluidigm)
# remove the mergeClusters step from the object
clusterLabels(rsecFluidigm)
test<-removeClusterings(rsecFluidigm,whichClusters="mergeClusters")
clusterLabels(test)
tableClusters(rsecFluidigm)
test<-removeClusters(rsecFluidigm,whichCluster="mergeClusters",clustersToRemove=c("m01","m04"))
tableClusters(test,whichCluster="mergeClusters")
}
