% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addEditingSites.R
\name{addEditingSites}
\alias{addEditingSites}
\alias{addEditingSites,GuideSet-method}
\alias{addEditingSites,PairedGuideSet-method}
\alias{addEditingSites,NULL-method}
\title{Add optimal editing site for base editing gRNAs.}
\usage{
addEditingSites(object, ...)

\S4method{addEditingSites}{GuideSet}(object, substitution)

\S4method{addEditingSites}{PairedGuideSet}(object, substitution)

\S4method{addEditingSites}{NULL}(object)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{substitution}{String indicating which substitution
should be used to estimate the optimal editing position. 
E.g. "C2T" will return the optimal editing position for C to T
editing.}
}
\value{
An updated object with a colum \code{editing_site} added to
    \code{mcols(object)}.
}
\description{
Add optimal editing site for base editing gRNAs.
}
\author{
Jean-Philippe Fortin
}
