% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsDesign.R
\name{updateOpsLibrary}
\alias{updateOpsLibrary}
\title{Update OPS library with additional gRNAs}
\usage{
updateOpsLibrary(
  opsLibrary,
  df,
  n_guides = 4,
  gene_field = "gene",
  min_dist_edit = 2,
  dist_method = c("hamming", "levenshtein"),
  splitByChunks = FALSE
)
}
\arguments{
\item{opsLibrary}{data.frame obtained from \code{designOpsLibrary}.}

\item{df}{data.frame containing information about additional
candidate gRNAs to add to the OPS library.}

\item{n_guides}{Integer specifying how many gRNAs per
gene should be selected. 4 by default.}

\item{gene_field}{String specifying the column in \code{df}
specifying gene names.}

\item{min_dist_edit}{Integer specifying the minimum distance edit
required for barcodes to be considered dissimilar. Barcodes that
have edit distances less than the min_dist_edit will not be
included in the library. 2 by default.}

\item{dist_method}{String specifying distance method. 
Must be either "hamming" (default) or "levenshtein".}

\item{splitByChunks}{Should distances be calculated in a chunk-wise
manner? FALSE by default. Highly recommended when the set of query
barcodes is large to reduce memory footprint.}
}
\value{
A data.frame containing the original gRNAs from 
   the input \code{opsLibrary} data.frame as well as additional
   gRNAs selected from the input data.frame \code{df}.
}
\description{
Update OPS library with additional gRNAs
}
\examples{
data(guideSetExample, package="crisprDesign")
guideSet <- unique(guideSetExample)
guideSet <- addOpsBarcodes(guideSet)
guideSet1 <- guideSet[1:200]
guideSet2 <- guideSet[201:400]

df1 <- data.frame(ID=names(guideSet1),
                  spacer=spacers(guideSet1, as.character=TRUE),
                  opsBarcode=as.character(guideSet1$opsBarcode))
df2 <- data.frame(ID=names(guideSet2),
                  spacer=spacers(guideSet2, as.character=TRUE),
                  opsBarcode=as.character(guideSet2$opsBarcode))

# Creating mock gene:
df1$gene <- rep(paste0("gene",1:10),each=20)
df2$gene <- rep(paste0("gene",1:10+10),each=20)
df1$rank <- rep(1:20,10)
df2$rank <- rep(1:20,10)
opsLib <- designOpsLibrary(df1)
opsLib <- updateOpsLibrary(opsLib, df2)

}
\author{
Jean-Philippe Fortin
}
