% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSummaryOnPi.R
\name{getSummaryOnPi}
\alias{getSummaryOnPi}
\title{Extract summary statistics and diagnostics on fitted cell type proportions}
\usage{
getSummaryOnPi(
  posterior,
  probs = c(0.025, 0.25, 0.5, 0.75, 0.975),
  digits_summary = 5,
  cell_type_names = NULL,
  ...
)
}
\arguments{
\item{posterior}{The fitted posterior object from decemedip model.}

\item{probs}{A numeric vector specifying quantiles of interest. The defaults
is c(0.025,0.25,0.5,0.75,0.975).}

\item{digits_summary}{The number of significant digits to use in the summary,
defaulting to 5.}

\item{cell_type_names}{Name of the cell types in reference panel. The order
should align with order in the reference panel.}

\item{...}{Additional arguments that get passed into \code{rstan::monitor} function.}
}
\value{
A data.frame object containg summary statistics and diagnostic statistics
of the fitted cell type proportions.
}
\description{
Extract summary statistics and diagnostics on fitted cell type proportions
}
\examples{

data(pdx.counts.cts.se)
data(pdx.counts.anc.se)
# read counts of cell type-specific CpGs of the sample 'LuCaP_147CR'
counts_cts <- SummarizedExperiment::assays(pdx.counts.cts.se)$counts[, "LuCaP_147CR"]
# read counts of anchor CpGs of the sample 'LuCaP_147CR'
counts_anc <- SummarizedExperiment::assays(pdx.counts.anc.se)$counts[, "LuCaP_147CR"]

## The following functions are commented due to Bioconductor's time constraints on package building
## Fit decemedip model
# output <- decemedip(counts_cts = counts_cts, counts_anc = counts_anc)
## Get summary stats
# smr_pi.df <- getSummaryOnPi(output$posterior)

}
