% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{data}
\name{hg19.ref.anc.se}
\alias{hg19.ref.anc.se}
\title{Hg19 genomic information of anchor CpGs (i.e., all-tissue unmethylated/methylation
probes) inferred from DNA methylation atlas published by Moss 2018 Nat. Commun.
(https://www.nature.com/articles/s41467-018-07466-6). Used as default in \code{\link{decemedip}}.}
\format{
An object of class \code{SummarizedExperiment}.
}
\usage{
data(hg19.ref.anc.se)
}
\description{
This dataset represents a GRanges object that contains the collection
of Illumina HumanMethylation450K probes that have methylation level less than 0.1 or
greater than 0.9 in all tissue present in the atlas. Data source is from the MethAtlas
GitHub repo (\url{https://github.com/nloyfer/meth_atlas}).
}
\details{
All coordinates are in hg19.
}
\examples{
data(hg19.ref.anc.se)
hg19.ref.anc.se
}
\references{
Moss, J., Magenheim, J., Neiman, D. et al. Comprehensive human
cell-type methylation atlas reveals origins of circulating cell-free DNA in
health and disease. \emph{Nat Commun 9, 5068} (2018).
}
\keyword{datasets}
