% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusConcordants.R
\name{.groupByTargetAndSelectMax}
\alias{.groupByTargetAndSelectMax}
\title{Group concordants by target and select maximum similarity entries}
\usage{
.groupByTargetAndSelectMax(concordants)
}
\arguments{
\item{concordants}{A dataframe containing filtered concordants data.}
}
\value{
A dataframe with deduplicated targets, keeping maximum similarity entries.
}
\description{
This internal function groups concordants data by target (compound or treatment)
and retains only the entries with maximum absolute similarity for each target.
}
\details{
This function:
\enumerate{
\item Groups by treatment or compound columns (whichever is available)
\item For each group, retains only entries with maximum absolute similarity
\item Handles ties by keeping all tied entries
\item Preserves the structure for downstream processing
}
}
\examples{
\dontrun{
testData <- data.frame(
    compound = c("A", "A", "B", "B"),
    similarity = c(0.5, 0.8, -0.3, -0.7),
    cellline = c("A375", "PC3", "A375", "PC3")
)
grouped <- .groupByTargetAndSelectMax(testData)
# Returns entries with max |similarity| for each compound
}
}
\keyword{internal}
