% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{.loadMetadata}
\alias{.loadMetadata}
\title{Load the correct metadata table for a given library}
\usage{
.loadMetadata(lib)
}
\arguments{
\item{lib}{A character string specifying the library type.
Must be one of "OE", "KD", or "CP".}
}
\value{
A tibble containing the metadata for the specified library.
The structure varies by library type but typically includes columns
for signature identifiers, treatments, cell lines, and other metadata.
}
\description{
This internal function retrieves the appropriate metadata table based on
the specified iLINCS library type.
}
\details{
The function loads pre-compiled metadata tables for each library:
\itemize{
\item \code{"OE"}: Overexpression metadata (\code{oeMetadata})
\item \code{"KD"}: Knockdown metadata (\code{kdMetadata})
\item \code{"CP"}: Chemical Perturbagen metadata (\code{cpMetadata})
}

These metadata tables are included with the package and contain information
about available signatures in each iLINCS library.
}
\examples{
NULL
}
\keyword{internal}
