% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSignature.R
\name{.processSuccessfulResponse}
\alias{.processSuccessfulResponse}
\title{Process successful API response into signature data frame}
\usage{
.processSuccessfulResponse(response)
}
\arguments{
\item{response}{An httr2 response object from a successful iLINCS API call.}
}
\value{
A tibble containing the signature data with standardized columns:
* signatureID: The signature identifier
* ID_geneid: Character gene identifiers
* Name_GeneSymbol: Gene symbols
* Value_LogDiffExp: Log fold-change values (rounded to 12 decimal places)
* Significance_pvalue: P-values (rounded to 12 decimal places)
}
\description{
This internal function processes a successful HTTP response from the iLINCS
API and converts it into a standardized signature data frame.
}
\details{
This function:
\enumerate{
\item Extracts JSON data from the response body
\item Maps the "signature" elements from the response
\item Flattens the nested structure into a data frame
\item Removes the "PROBE" column (not needed for analysis)
\item Converts gene IDs to character format
\item Rounds numeric values to 12 decimal places for consistency
\item Adds signature metadata including L1000 status
}

The rounding ensures consistent precision across different platforms and
prevents floating-point precision issues in downstream analyses.
}
\examples{
NULL
}
\keyword{internal}
