% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSignature.R
\name{getSignature}
\alias{getSignature}
\title{Get the L1000 Signature from iLINCS
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}}
\usage{
getSignature(sigId)
}
\arguments{
\item{sigId}{character. The ilincs signature_id}
}
\value{
a tibble with the signature data containing the following columns:
* \code{signatureID}: The signature identifier
* \code{ID_geneid}: Gene IDs (Entrez)
* \code{Name_GeneSymbol}: Gene symbols
* \code{Value_LogDiffExp}: Log fold-change values
* \code{Significance_pvalue}: Statistical significance p-values
}
\description{
This function acts as the entrypoint to the iLINCS database.
This takes in an ID and returns the signature after making a
call to the iLINCS database. The function automatically detects
whether the signature is an L1000 signature based on the signature ID
and metadata tables, and retrieves all available genes for comprehensive
signature analysis.
}
\examples{
# Input validation example (no API call)
# Demonstrates proper signature ID format validation
tryCatch(
    getSignature(""), # Empty string should error
    error = function(e) message("Expected error: empty signature ID")
)

\donttest{
# These examples require network access to the iLINCS API

# Get the L1000 signature for LINCSKD_28
kdSignature <- getSignature("LINCSKD_28")
head(kdSignature)

# Get an overexpression signature (L1000 status is automatically detected)
oeSignature <- getSignature("LINCSOE_1000")
head(oeSignature)

# Check the structure of retrieved signature
str(kdSignature)
}
}
