% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiSeeker-package.R
\docType{data}
\name{demo_bmdata}
\alias{demo_bmdata}
\title{demo base modification data}
\format{
A \code{bmData} object containing one sample.
}
\value{
bmData object
}
\description{
A small example \code{bmData} object representing cytosine methylation
measurements from Bisulfite-Seq data.  
This dataset is intended for demonstrating base-modification visualization,
regional methylation profiling, and \code{epiSeeker} workflows operating on
\code{bmData} objects. 
See data-raw/example_data.R
}
\section{Provenance}{

The example dataset was constructed from publicly available Bisulfite-Seq
data (GEO accession: \code{GSM6940395}, genome build: hg38).  
The raw methylation coverage file (\code{*.bismark.cov.gz}) was imported
using \pkg{data.table::fread()}.

A small genomic window on chromosome 22
(\code{[10525991, 10526342]}) was selected to create a lightweight example
dataset. The data were processed as follows:
\enumerate{
  \item Filter records where \code{chrom == 22} and positions fall within
        the chosen window.
  \item Convert chromosome name to UCSC style (\code{"chr22"}).
  \item Compute total coverage as: \code{Cov = methylated + unmethylated}.
  \item Extract columns: chromosome, position, coverage, and methylation
        percentage.
  \item Convert methylation percentage to a fraction.
}
}

\section{Data structure}{

A \code{bmData} S4 object containing one sample (\code{"acinar_methyl"}).  
Each entry stores:
\describe{
  \item{\code{chr}}{Chromosome in UCSC format (e.g. \code{"chr22"}).}
  \item{\code{pos}}{Genomic coordinate of the cytosine.}
  \item{\code{Cov}}{Total read coverage at the site.}
  \item{\code{Methylation}}{Methylation level as a fraction (0–1).}
}
}

