% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTagMatrix.R
\name{plotPeakHeatmap}
\alias{plotPeakHeatmap}
\title{plotPeakHeatmap function}
\usage{
plotPeakHeatmap(
  tagMatrix,
  plot_prof = TRUE,
  xlab = "",
  ylab = "",
  palette = NULL,
  title = NULL,
  facet_label_text_size = 12,
  nrow = NULL,
  ncol = NULL,
  conf = NULL,
  statistic_method = "mean",
  missingDataAsZero = TRUE,
  facet = "none",
  free_y = TRUE,
  height_proportion = 4,
  ...
)
}
\arguments{
\item{tagMatrix}{output from getTagMatrix().}

\item{plot_prof}{combine prof or not. Default: TRUE}

\item{xlab}{xlab.}

\item{ylab}{ylab.}

\item{palette}{palette to be filled in,details see \link[ggplot2]{scale_colour_brewer}.}

\item{title}{title.}

\item{facet_label_text_size}{the size of facet label text}

\item{nrow}{nrow to place a number of fig.}

\item{ncol}{ncol to place a number of fig.}

\item{conf}{confidence interval.}

\item{statistic_method}{method to do statistic. one of "mean", "median", "min", "max", "sum", "std"}

\item{missingDataAsZero}{set missing data as zero or not.}

\item{facet}{one of 'none', 'row' and 'column'.}

\item{free_y}{if TRUE, y will be scaled.}

\item{height_proportion}{the proportion of profiling picture and heatmap}

\item{...}{additional parameters}
}
\value{
ggplot object
}
\description{
plotPeakHeatmap function
}
\examples{
data(tagMatrix)
plotPeakHeatmap(tagMatrix)
}
