% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{inverseLogicleTransform}
\alias{inverseLogicleTransform}
\title{Computes the inverse of the transform defined by the 'logicleTransform'
function or the transformList generated by 'estimateLogicle' function}
\usage{
inverseLogicleTransform(trans,transformationId,...)
}
\arguments{
\item{trans}{An object of class 'transform' created using the
'logicleTransform' function or class 'transformList' created by
'estimateLogicle'.  The parameters w, t, m, a for calculating the inverse
are obtained from the 'trans' input passed to the 'inverseLogicleTransform'
function.}

\item{transformationId}{A name to assigned to the inverse transformation.
Used by the transform routines.}

\item{...}{not used.}
}
\description{
inverseLogicleTransform can be use to compute the inverse of the Logicle
transformation. The parameters w, t, m, a for calculating the inverse are
obtained from the 'trans' input passed to the 'inverseLogicleTransform'
function. (The inverseLogicleTransform method makes use of the C++
implementation of the inverse logicle transform contributed by Wayne Moore
et al.)
}
\examples{

data(GvHD)
samp <- GvHD[[1]] 

#########inverse the transform object###############
logicle  <- logicleTransform(t = 10000, w = 0.5, m = 4.5 , a =0 ,"logicle")
## transform FL1-H parameter using logicle transformation
after <- transform(samp, transformList('FL1-H', logicle))

## Inverse transform the logicle transformed data to retrieve the original data
invLogicle <- inverseLogicleTransform(trans = logicle)
before <- transform (after, transformList('FL1-H', invLogicle))

#########inverse the transformList object###############
translist <- estimateLogicle(samp, c("FL1-H", "FL2-H"))
after <- transform(samp, translist)
## Inverse 
invLogicle <- inverseLogicleTransform(translist)
before <- transform (after, invLogicle)

}
\references{
Parks D.R., Roederer M., Moore W.A.(2006) A new "logicle"
display method avoids deceptive effects of logarithmic scaling for low
signals and compensated data. CytometryA, 96(6):541-51.
}
\seealso{
\code{\link[flowCore]{logicleTransform}}

Other Transform functions: 
\code{\link{arcsinhTransform}()},
\code{\link{biexponentialTransform}()},
\code{\link{linearTransform}()},
\code{\link{lnTransform}()},
\code{\link{logTransform}()},
\code{\link{logicleTransform}()},
\code{\link{quadraticTransform}()},
\code{\link{scaleTransform}()},
\code{\link{splitScaleTransform}()},
\code{\link{truncateTransform}()}
}
\author{
Wayne Moore, N. Gopalakrishnan
}
\concept{Transform functions}
\keyword{methods}
